//  Demonstrates use of lwp_wait_true/wait_false. Written by
//  Paolo De Marino (paolodemarino@usa.net)
//  This demo file is FREEWARE - you can do whatever you want with it.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING. If not, write to the
//  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include <conio.h>
#include "lwp.h"
#include "lwpconio.h"
#include "lwpstdio.h"

volatile int siga = 0, sigb = 0;

void 
proc (void *unused)
{
  printf ("Step 1!\n");
  lwp_wait_false (&siga);       // It is, go on!

  printf ("Step 2!\n");
  siga = 1;
  lwp_wait_true (&sigb);
  printf ("Step 4!\n");
  sigb = 0;
}

int 
main ()
{
  int id;

  if (lwp_init (8, RTC128))

    {
      id = lwp_spawn (proc, (void*)0,4096, 1);

      lwp_wait_true (&siga);
      printf ("Step 3!\n");
      sigb = 1;
      lwp_wait_false (&sigb);
      printf ("Step 5!\n");

    };
  return (0);
}
