# GNU MAKE (3.79.1) Makefile for PDCurses library - DOS DJGPP V2.0+
#
# Usage: make -f [path\]gccdos.mak [DEBUG=Y] [target]
#
# where target can be any of:
# [all|libs|demos|manual|dist|install|libpdcurses.a|testcurs.exe...]
#
# Target `install' will install the products in the standard places
# for a stock DJGPP installation given by the value of the environment
# variable DJDIR.
# If the user prefers to install in some other directory, he must
# supply a new value for the variable prefix at the command line
# like this:
#   make -f [path\]gccdos.mak install prefix=/some/other/dir

O = o

ifndef PDCURSES_SRCDIR
	PDCURSES_SRCDIR = ..
endif

include $(PDCURSES_SRCDIR)/version.mif
include $(PDCURSES_SRCDIR)/libobjs.mif

osdir		= $(PDCURSES_SRCDIR)/dos

PDCURSES_DOS_H	= $(osdir)/pdcdos.h

prefix		= /dev/env/DJDIR
includedir	= $(prefix)/include
libdir		= $(prefix)/lib
docdir		= $(prefix)/contrib/PDCurses.$(VER)
gnudocsdir	= $(prefix)/gnudocs/PDCurses.$(VER)

CC		= gcc

ifeq ($(DEBUG),Y)
	CFLAGS  = -g -Wall -DPDCDEBUG
	LDFLAGS = -g
else
	CFLAGS  = -O2 -Wall
	LDFLAGS =
endif

CFLAGS += -I$(PDCURSES_SRCDIR)

LINK		= gcc

LIBEXE		= ar
LIBFLAGS	= rcv

LIBCURSES	= libpdcurses.a
LIBPANEL	= libpanel.a

CP		= /dev/env/DJDIR/bin/cp
RM		= /dev/env/DJDIR/bin/rm
STRIP		= /dev/env/DJDIR/bin/strip
INSTALL		= /dev/env/DJDIR/bin/ginstall

.PHONY: all libs clean demos dist install

all:	libs demos manual

libs:	$(LIBCURSES)

clean:
	-$(RM) *.o
	-$(RM) *.a
	-$(RM) *.exe

demos:	$(DEMOS)
	$(STRIP) *.exe

manual:
	$(MAKE) -C $(PDCURSES_SRCDIR)/doc $@

install: $(LIBCURSES) manual
	$(INSTALL) -d $(includedir)
	$(INSTALL) -d $(libdir)
	$(INSTALL) -d $(docdir)
	$(INSTALL) -d $(gnudocsdir)
	$(INSTALL) $(PDCURSES_SRCDIR)/curses.h $(includedir)
	$(INSTALL) $(PDCURSES_SRCDIR)/panel.h $(includedir)
	$(INSTALL) $(PDCURSES_SRCDIR)/term.h $(includedir)
	$(INSTALL) $(LIBCURSES) $(libdir)
	$(INSTALL) $(LIBPANEL) $(libdir)
	$(INSTALL) $(PDCURSES_SRCDIR)/README $(docdir)
	$(INSTALL) $(PDCURSES_SRCDIR)/HISTORY $(docdir)
	$(INSTALL) $(PDCURSES_SRCDIR)/IMPLEMNT $(docdir)
	$(INSTALL) $(PDCURSES_SRCDIR)/doc/PDCurses.txt $(gnudocsdir)

$(LIBCURSES) : $(LIBOBJS) $(PDCOBJS)
	$(LIBEXE) $(LIBFLAGS) $@ $?
	-$(CP) $(LIBCURSES) $(LIBPANEL)

$(LIBOBJS) $(PDCOBJS) : $(PDCURSES_HEADERS)
$(PDCOBJS) : $(PDCURSES_DOS_H)
$(DEMOS) : $(PDCURSES_CURSES_H) $(LIBCURSES)
panel.o : $(PANEL_HEADER)
terminfo.o: $(TERM_HEADER)

$(LIBOBJS) : %.o: $(srcdir)/%.c
	$(CC) -c $(CFLAGS) $<

$(PDCOBJS) : %.o: $(osdir)/%.c
	$(CC) -c $(CFLAGS) $<

firework.exe newdemo.exe rain.exe testcurs.exe worm.exe xmas.exe \
ptest.exe: %.exe: $(demodir)/%.c
	$(CC) $(CFLAGS) -o$@ $< $(LIBCURSES)

tuidemo.exe: tuidemo.o tui.o
	$(LINK) $(LDFLAGS) -o$@ tuidemo.o tui.o $(LIBCURSES)

tui.o: $(demodir)/tui.c $(demodir)/tui.h $(PDCURSES_CURSES_H)
	$(CC) -c $(CFLAGS) -I$(demodir) -o$@ $<

tuidemo.o: $(demodir)/tuidemo.c $(PDCURSES_CURSES_H)
	$(CC) -c $(CFLAGS) -I$(demodir) -o$@ $<

PLATFORM1 = DJGPP 2.03
PLATFORM2 = DJGPP 2.03 for DOS
ARCNAME = pdc$(VER)djg

include $(PDCURSES_SRCDIR)/makedist.mif
