#########################################################################
#
# GNU MAKE (3.79.1) Makefile for PDCurses library - DOS DJGPP V2.0+
#
# Usage: make -f [path\]gccdos.mak [-DDEBUG] [target]
#
# where target can be any of:
# [all|libs|demos|dist|install|pdcurses.a|testcurs.exe...]
#
#########################################################################

O = o

ifndef PDCURSES_SRCDIR
	PDCURSES_SRCDIR = ..
endif

include $(PDCURSES_SRCDIR)/version.mif
include $(PDCURSES_SRCDIR)/libobjs.mif

osdir		= $(PDCURSES_SRCDIR)/dos

PDCURSES_DOS_H	= $(osdir)/pdcdos.h

CC		= gcc

ifeq ($(DEBUG),Y)
	CFLAGS  = -g -Wall -DPDCDEBUG
	LDFLAGS = -g
else
	CFLAGS  = -O2 -Wall
	LDFLAGS =
endif

CFLAGS += -I$(PDCURSES_SRCDIR)

LINK		= gcc

LIBEXE		= ar
LIBFLAGS	= rcv

LIBCURSES	= libpdcurses.a
LIBPANEL	= libpanel.a

#########################################################################
# This reproduces the standard installation directory tree of a
# stock DJGPP distribution.
#
# It will install the products in the standard places for a stock
# DJGPP installation given by the value of the environment variable
# DJDIR.
# If the user prefers to install in some other directory, he must
# supply a new value for the variable prefix at the command line
# like this:
#   make -f [path\]gccdos.mak install prefix=/some/other/dir
#########################################################################
prefix		= /dev/env/DJDIR
includedir	= $(prefix)/include
libdir		= $(prefix)/lib
docdir		= $(prefix)/contrib/pdcurses.$(VER)
mandir		= $(prefix)/contrib/pdcurses.$(VER)/doc


RM		= /dev/env/DJDIR/bin/rm
INSTALL		= /dev/env/DJDIR/bin/ginstall
#########################################################################
.PHONY: all libs clean demos dist install

all:	libs demos

libs:	$(LIBCURSES)

clean:
	-del *.o
	-del *.a
	-del *.exe

demos:	$(DEMOS)
	strip *.exe

install: $(LIBCURSES)
	$(INSTALL) -d $(includedir)
	$(INSTALL) -d $(libdir)
	$(INSTALL) -d $(docdir)
	$(INSTALL) -d $(mandir)
	$(INSTALL) $(PDCURSES_SRCDIR)/curses.h $(includedir)
	$(INSTALL) $(PDCURSES_SRCDIR)/curspriv.h $(includedir)
	$(INSTALL) $(PDCURSES_SRCDIR)/panel.h $(includedir)
	$(INSTALL) $(PDCURSES_SRCDIR)/term.h $(includedir)
	$(INSTALL) $(LIBCURSES) $(libdir)
	$(INSTALL) $(LIBPANEL) $(libdir)
	$(INSTALL) $(PDCURSES_SRCDIR)/README $(docdir)
	$(INSTALL) $(PDCURSES_SRCDIR)/HISTORY $(docdir)
	$(INSTALL) $(PDCURSES_SRCDIR)/IMPLEMNT $(docdir)
	$(INSTALL) $(PDCURSES_SRCDIR)/maintain.er $(docdir)
	$(INSTALL) $(PDCURSES_SRCDIR)/doc/intro.txt $(mandir)
	$(INSTALL) $(PDCURSES_SRCDIR)/doc/sdl.txt $(mandir)
	$(INSTALL) $(PDCURSES_SRCDIR)/doc/x11.txt $(mandir)

#------------------------------------------------------------------------

$(LIBCURSES) : $(LIBOBJS) $(PDCOBJS)
	$(LIBEXE) $(LIBFLAGS) $@ $?
	-cp $(LIBCURSES) $(LIBPANEL)

$(LIBOBJS) $(PDCOBJS) : $(PDCURSES_HEADERS)
$(PDCOBJS) : $(PDCURSES_DOS_H)
$(DEMOS) : $(PDCURSES_CURSES_H) $(LIBCURSES)
panel.o : $(PANEL_HEADER)
terminfo.o: $(TERM_HEADER)

$(LIBOBJS) : %.o: $(srcdir)/%.c
	$(CC) -c $(CFLAGS) $<

$(PDCOBJS) : %.o: $(osdir)/%.c
	$(CC) -c $(CFLAGS) $<

#------------------------------------------------------------------------

firework.exe newdemo.exe rain.exe testcurs.exe worm.exe xmas.exe \
ptest.exe: %.exe: $(demodir)/%.c
	$(CC) $(CFLAGS) -o$@ $< $(LIBCURSES)

tuidemo.exe: tuidemo.o tui.o
	$(LINK) $(LDFLAGS) -o$@ $? $(LIBCURSES)

tui.o: $(demodir)/tui.c $(demodir)/tui.h $(PDCURSES_CURSES_H)
	$(CC) -c $(CFLAGS) -I$(demodir) -o$@ $<

tuidemo.o: $(demodir)/tuidemo.c $(PDCURSES_CURSES_H)
	$(CC) -c $(CFLAGS) -I$(demodir) -o$@ $<

#------------------------------------------------------------------------

PLATFORM1 = DJGPP 2.03
PLATFORM2 = DJGPP 2.03 for DOS
ARCNAME = pdc$(VER)djg

include $(PDCURSES_SRCDIR)/makedist.mif
