
       Entering High-Order Characters of the Latin-1 Character Set
       -----------------------------------------------------------

When built without XIM support, PDCurses for X11 provides its own, 
limited compose key system for Latin-1 characters. The available 
combinations are listed here. For a given character, any of the 
combinations shown in the last column may be used. To generate a 
character, press the "compose" key followed by one of the pairs of 
keystrokes. Where no key is evident, the spacebar is used.  Thus, to 
generate the NO-BREAK SPACE, press the "compose" key followed by two 
hits of the spacebar.

With a typical modern X server, you can get many more compose key 
combinations by using XIM instead. Configure PDCurses with --enable-xim 
to use XIM support.

This document is encoded in UTF-8.

+----+-----+---+---------------------------------+---------------------------+
|Hex | Dec |Chr| Description ISO 10646-1:1993(E) | Compose key combinations  |
+----+-----+---+---------------------------------+---------------------------+
| A0 | 160 |   | NO-BREAK SPACE			 |			     |
| A1 | 161 | ¡ | INVERTED EXCLAMATION MARK	 | !   !!		     |
| A2 | 162 | ¢ | CENT SIGN			 | c|  |c  c/  c$  C$  C|    |
| A3 | 163 | £ | POUND SIGN			 | L-  L$  L=  l-  l$  l=  |-|
| A4 | 164 | ¤ | CURRENCY SIGN			 | xo  ox  XO  g$	     |
| A5 | 165 | ¥ | YEN SIGN			 | =y  y=  =Y  Y=  Y-  y$  y-|
| A6 | 166 | ¦ | BROKEN BAR			 | |   ||  vb  VB  |^	     |
| A7 | 167 | § | SECTION SIGN			 | SO  SS  s!  S!  so	     |
| A8 | 168 | ¨ | DIAERESIS			 | "   ""		     |
| A9 | 169 | © | COPYRIGHT SIGN			 | CO  co  OC		     |
| AA | 170 | ª | FEMININE ORDINAL INDICATOR	 | sa  SA  a_  A_	     |
| AB | 171 | « | LEFT DOUBLE ANGLE QUOTES	 | <<			     |
| AC | 172 | ¬ | NOT SIGN			 | -,  no  NO		     |
| AD | 173 | ­ | SOFT HYPHEN			 | -   --		     |
| AE | 174 | ® | REGISTERED SIGN		 | RO  ro  OR		     |
| AF | 175 | ¯ | MACRON				 | -^  _^  __		     |
| B0 | 176 | ° | DEGREE SIGN			 | o   0^  0*  de  DE  ^0    |
| B1 | 177 | ± | PLUS-MINUS SIGN		 | -+  +-		     |
| B2 | 178 | ² | SUPERSCRIPT TWO		 | 2   2^  s2  ^2	     |
| B3 | 179 | ³ | SUPERSCRIPT THREE		 | 3   3^  s3  ^3	     |
| B4 | 180 | ´ | ACUTE ACCENT			 | '   ''		     |
| B5 | 181 | µ | MICRO SIGN			 | u   /u  /U  *m  *M	     |
| B6 | 182 | ¶ | PILCROW SIGN			 | p!  P!  pg  PG	     |
| B7 | 183 | · | MIDDLE DOT			 | .   .^  ..		     |
| B8 | 184 | ¸ | CEDILLA			 | ,   ,,		     |
| B9 | 185 | ¹ | SUPERSCRIPT ONE		 | 1   1^  s1  ^1	     |
| BA | 186 | º | MASCULINE ORDINAL INDICATOR	 | o_  s0  S0		     |
| BB | 187 | » | RIGHT DOUBLE ANGLE QUOTES	 | >>			     |
| BC | 188 | ¼ | VULGAR FRACTION ONE QUARTER	 | 14			     |
| BD | 189 | ½ | VULGAR FRACTION ONE HALF	 | 12			     |
| BE | 190 | ¾ | VULGAR FRACTION THREE QUARTERS  | 34			     |
| BF | 191 | ¿ | INVERTED QUESTION MARK		 | ?   ??		     |
| C0 | 192 | À | CAPITAL A WITH GRAVE ACCENT	 | `A  A`		     |
| C1 | 193 | Á | CAPITAL A WITH ACUTE ACCENT	 | 'A  A'		     |
| C2 | 194 | Â | CAPITAL A WITH CIRCUMFLEX ACCENT| ^A  A^  A>		     |
| C3 | 195 | Ã | CAPITAL A WITH TILDE		 | ~A  A~  A-		     |
| C4 | 196 | Ä | CAPITAL A WITH DIAERESIS	 | "A  A"		     |
| C5 | 197 | Å | CAPITAL A WITH RING ABOVE	 | oA  Ao  A*  OA  *A	     |
| C6 | 198 | Æ | CAPITAL LIGATURE AE		 | AE			     |
| C7 | 199 | Ç | CAPITAL C WITH CEDILLA		 | ,C  C,		     |
| C8 | 200 | È | CAPITAL E WITH GRAVE ACCENT	 | `E  E`		     |
| C9 | 201 | É | CAPITAL E WITH ACUTE ACCENT	 | 'E  E'		     |
| CA | 202 | Ê | CAPITAL E WITH CIRCUMFLEX ACCENT| ^E  E^  E>		     |
| CB | 203 | Ë | CAPITAL E WITH DIAERESIS	 | "E  E"		     |
| CC | 204 | Ì | CAPITAL I WITH GRAVE ACCENT	 | `I  I`		     |
| CD | 205 | Í | CAPITAL I WITH ACUTE ACCENT	 | 'I  I'		     |
| CE | 206 | Î | CAPITAL I WITH CIRCUMFLEX ACCENT| ^I  I^  I>		     |
| CF | 207 | Ï | CAPITAL I WITH DIAERESIS	 | "I  I"		     |
| D0 | 208 | Ð | CAPITAL ETH			 | D-			     |
| D1 | 209 | Ñ | CAPITAL N WITH TILDE		 | ~N  N~  N-		     |
| D2 | 210 | Ò | CAPITAL O WITH GRAVE ACCENT	 | `O  O`		     |
| D3 | 211 | Ó | CAPITAL O WITH ACUTE ACCENT	 | 'O  O'		     |
| D4 | 212 | Ô | CAPITAL O WITH CIRCUMFLEX ACCENT| ^O  O^  O>		     |
| D5 | 213 | Õ | CAPITAL O WITH TILDE		 | ~O  O~  O-		     |
| D6 | 214 | Ö | CAPITAL O WITH DIAERESIS	 | "O  O"		     |
| D7 | 215 | × | MULTIPLICATION SIGN		 | x   xx  XX  mu  MU	     |
| D8 | 216 | Ø | CAPITAL O WITH STROKE		 | /O  O/		     |
| D9 | 217 | Ù | CAPITAL U WITH GRAVE ACCENT	 | `U  U`		     |
| DA | 218 | Ú | CAPITAL U WITH ACUTE ACCENT	 | 'U  U'		     |
| DB | 219 | Û | CAPITAL U WITH CIRCUMFLEX ACCENT| ^U  U^  U>		     |
| DC | 220 | Ü | CAPITAL U WITH DIAERESIS	 | "U  U"		     |
| DD | 221 | Ý | CAPITAL Y WITH ACUTE ACCENT	 | 'Y  Y'		     |
| DE | 222 | Þ | CAPITAL THORN			 | P   TH  |P		     |
| DF | 223 | ß | SMALL SHARP S			 | ss			     |
| E0 | 224 | à | SMALL A WITH GRAVE ACCENT	 | `a  a`		     |
| E1 | 225 | á | SMALL A WITH ACUTE ACCENT	 | 'a  a'		     |
| E2 | 226 | â | SMALL A WITH CIRCUMFLEX ACCENT  | ^a  a^  a>		     |
| E3 | 227 | ã | SMALL A WITH TILDE		 | ~a  a~  a-		     |
| E4 | 228 | ä | SMALL A WITH DIAERESIS		 | "a  a"		     |
| E5 | 229 | å | SMALL A WITH RING ABOVE	 | oa  ao  Oa  a*  *a	     |
| E6 | 230 | æ | SMALL LIGATURE AE		 | ae			     |
| E7 | 231 | ç | SMALL C WITH CEDILLA		 | ,c  c,		     |
| E8 | 232 | è | SMALL E WITH GRAVE ACCENT	 | `e  e`		     |
| E9 | 233 | é | SMALL E WITH ACUTE ACCENT	 | 'e  e'		     |
| EA | 234 | ê | SMALL E WITH CIRCUMFLEX ACCENT  | ^e  e^  e>		     |
| EB | 235 | ë | SMALL E WITH DIAERESIS		 | "e  e"		     |
| EC | 236 | ì | SMALL I WITH GRAVE ACCENT	 | `i  i`		     |
| ED | 237 | í | SMALL I WITH ACUTE ACCENT	 | 'i  i'		     |
| EE | 238 | î | SMALL I WITH CIRCUMFLEX ACCENT  | ^i  i^  i>		     |
| EF | 239 | ï | SMALL I WITH DIAERESIS		 | "i  i"		     |
| F0 | 240 | ð | SMALL ETH			 | d-			     |
| F1 | 241 | ñ | SMALL N WITH TILDE		 | ~n  n~  n-		     |
| F2 | 242 | ò | SMALL O WITH GRAVE ACCENT	 | `o  o`		     |
| F3 | 243 | ó | SMALL O WITH ACUTE ACCENT	 | 'o  o'		     |
| F4 | 244 | ô | SMALL O WITH CIRCUMFLEX ACCENT  | ^o  o^  o>		     |
| F5 | 245 | õ | SMALL O WITH TILDE		 | ~o  o~  o-		     |
| F6 | 246 | ö | SMALL O WITH DIAERESIS		 | "o  o"		     |
| F7 | 247 | ÷ | DIVISION SIGN			 | -:  :-		     |
| F8 | 248 | ø | SMALL O WITH OBLIQUE BAR	 | /o  o/		     |
| F9 | 249 | ù | SMALL U WITH GRAVE ACCENT	 | `u  u`		     |
| FA | 250 | ú | SMALL U WITH ACUTE ACCENT	 | 'u  u'		     |
| FB | 251 | û | SMALL U WITH CIRCUMFLEX ACCENT  | ^u  u^  u>		     |
| FC | 252 | ü | SMALL U WITH DIAERESIS		 | "u  u"		     |
| FD | 253 | ý | SMALL Y WITH ACUTE ACCENT	 | 'y  y'		     |
| FE | 254 | þ | SMALL THORN			 | p   th  |p		     |
| FF | 255 | ÿ | SMALL Y WITH DIAERESIS		 | "y  y"		     |
+----+-----+---+---------------------------------+---------------------------+
