
       Entering High-Order Characters of the Latin-1 Character Set
       -----------------------------------------------------------

The following table shows the high-order characters of the Latin-1 
character set and how to generate these characters using any keyboard 
and the user-specified "compose" key.

The last column shows all possible key combinations to generate the 
equivalent Latin-1 character.  There are up to 7 pairs of keys used per 
character, and these are listed in columns under the "Compose Key 
Combinations" heading.  To generate a character, press the "compose" key 
followed by one of the pairs of keystrokes.

Where no key is evident, the spacebar is used.  Thus, to generate the 
NO-BREAK SPACE, press the "compose" key followed by the spacebar, 
followed by the spacebar.

NOTE: Viewing this file with a character set other than Latin-1 will not 
show the Chr value correctly.

+----+-----+---+---------------------------------+---------------------------+
|Hex | Dec |Chr| Description ISO 10646-1:1993(E) | Compose key combinations  |
+----+-----+---+---------------------------------+---------------------------+
| A0 | 160 |   | NO-BREAK SPACE                  |                           |
| A1 | 161 |  | INVERTED EXCLAMATION MARK       | !   !!                    |
| A2 | 162 |  | CENT SIGN                       | c|  |c  c/  c$  C$  C|    |
| A3 | 163 |  | POUND SIGN                      | L-  L$  L=  l- l$  l=     |
| A4 | 164 |  | CURRENCY SIGN                   | xo  ox  XO  g$            |
| A5 | 165 |  | YEN SIGN                        | =y  y=  =Y  Y=  Y-  y$  y-|
| A6 | 166 |  | BROKEN BAR                      | |   ||  vb  VB  |^        |
| A7 | 167 |  | SECTION SIGN                    | SO  SS  s!  S!  so        |
| A8 | 168 |  | DIAERESIS                       | "   ""                    |
| A9 | 169 |  | COPYRIGHT SIGN                  | CO  co  OC                |
| AA | 170 |  | FEMININE ORDINAL INDICATOR      | sa  SA  a_  A_            |
| AB | 171 |  | LEFT DOUBLE ANGLE QUOTES        | <<                        |
| AC | 172 |  | NOT SIGN                        | -,  no  NO                |
| AD | 173 |  | SOFT HYPHEN                     | -   --                    |
| AE | 174 |  | REGISTERED SIGN                 | RO  ro  OR                |
| AF | 175 |  | MACRON                          | -^  _^  __                |
| B0 | 176 |  | DEGREE SIGN                     | o   0^  0*  de  DE        |
| B1 | 177 |  | PLUS-MINUS SIGN                 | -+  +-                    |
| B2 | 178 |  | SUPERSCRIPT TWO                 | 2   2^  s2                |
| B3 | 179 |  | SUPERSCRIPT THREE               | 3   3^  s3                |
| B4 | 180 |  | ACUTE ACCENT                    | '   ''                    |
| B5 | 181 |  | MICRO SIGN                      | u   /u  /U  *m  *M        |
| B6 | 182 |  | PILCROW SIGN                    | p!  P!  pg  PG            |
| B7 | 183 |  | MIDDLE DOT                      | .   .^  ..                |
| B8 | 184 |  | CEDILLA                         | ,   ,,                    |
| B9 | 185 |  | SUPERSCRIPT ONE                 | 1   1^  s1                |
| BA | 186 |  | MASCULINE ORDINAL INDICATOR     | o_  s0  S0                |
| BB | 187 |  | RIGHT DOUBLE ANGLE QUOTES       | >>                        |
| BC | 188 |  | VULGAR FRACTION ONE QUARTER     | 14                        |
| BD | 189 |  | VULGAR FRACTION ONE HALF        | 12                        |
| BE | 190 |  | VULGAR FRACTION THREE QUARTERS  | 34                        |
| BF | 191 |  | INVERTED QUESTION MARK          | ?   ??                    |
| C0 | 192 |  | CAPITAL A WITH GRAVE ACCENT     | `A  A`                    |
| C1 | 193 |  | CAPITAL A WITH ACUTE ACCENT     | 'A  A'                    |
| C2 | 194 |  | CAPITAL A WITH CIRCUMFLEX ACCENT| ^A  A^  A>                |
| C3 | 195 |  | CAPITAL A WITH TILDE            | ~A  A~  A-                |
| C4 | 196 |  | CAPITAL A WITH DIAERESIS        | "A  A"                    |
| C5 | 197 |  | CAPITAL A WITH RING ABOVE       | oA  Ao  A*  OA            |
| C6 | 198 |  | CAPITAL LIGATURE AE             | AE                        |
| C7 | 199 |  | CAPITAL C WITH CEDILLA          | ,C  C,                    |
| C8 | 200 |  | CAPITAL E WITH GRAVE ACCENT     | `E  E`                    |
| C9 | 201 |  | CAPITAL E WITH ACUTE ACCENT     | 'E  E'                    |
| CA | 202 |  | CAPITAL E WITH CIRCUMFLEX ACCENT| ^E  E^  E>                |
| CB | 203 |  | CAPITAL E WITH DIAERESIS        | "E  E"                    |
| CC | 204 |  | CAPITAL I WITH GRAVE ACCENT     | `I  I`                    |
| CD | 205 |  | CAPITAL I WITH ACUTE ACCENT     | 'I  I'                    |
| CE | 206 |  | CAPITAL I WITH CIRCUMFLEX ACCENT| ^I  I^  I>                |
| CF | 207 |  | CAPITAL I WITH DIAERESIS        | "I  I"                    |
| D0 | 208 |  | CAPITAL ETH                     | D-                        |
| D1 | 209 |  | CAPITAL N WITH TILDE            | ~N  N~  N-                |
| D2 | 210 |  | CAPITAL O WITH GRAVE ACCENT     | `O  O`                    |
| D3 | 211 |  | CAPITAL O WITH ACUTE ACCENT     | 'O  O'                    |
| D4 | 212 |  | CAPITAL O WITH CIRCUMFLEX ACCENT| ^O  O^  O>                |
| D5 | 213 |  | CAPITAL O WITH TILDE            | ~O  O~  O-                |
| D6 | 214 |  | CAPITAL O WITH DIAERESIS        | "O  O"                    |
| D7 | 215 |  | MULTIPLICATION SIGN             | x   xx  XX  mu  MU        |
| D8 | 216 |  | CAPITAL O WITH STROKE           | /O  O/                    |
| D9 | 217 |  | CAPITAL U WITH GRAVE ACCENT     | `U  U`                    |
| DA | 218 |  | CAPITAL U WITH ACUTE ACCENT     | 'U  U'                    |
| DB | 219 |  | CAPITAL U WITH CIRCUMFLEX ACCENT| ^U  U^  U>                |
| DC | 220 |  | CAPITAL U WITH DIAERESIS        | "U  U"                    |
| DD | 221 |  | CAPITAL Y WITH ACUTE ACCENT     | 'Y  Y'                    |
| DE | 222 |  | CAPITAL THORN                   | P   TH  |P                |
| DF | 223 |  | SMALL SHARP S                   | ss                        |
| E0 | 224 |  | SMALL A WITH GRAVE ACCENT       | `a  a`                    |
| E1 | 225 |  | SMALL A WITH ACUTE ACCENT       | 'a  a'                    |
| E2 | 226 |  | SMALL A WITH CIRCUMFLEX ACCENT  | ^a  a^  a>                |
| E3 | 227 |  | SMALL A WITH TILDE              | ~a  a~  a-                |
| E4 | 228 |  | SMALL A WITH DIAERESIS          | "a  a"                    |
| E5 | 229 |  | SMALL A WITH RING ABOVE         | oa  ao  Oa                |
| E6 | 230 |  | SMALL LIGATURE AE               | ae                        |
| E7 | 231 |  | SMALL C WITH CEDILLA            | ,c  c,                    |
| E8 | 232 |  | SMALL E WITH GRAVE ACCENT       | `e  e`                    |
| E9 | 233 |  | SMALL E WITH ACUTE ACCENT       | 'e  e'                    |
| EA | 234 |  | SMALL E WITH CIRCUMFLEX ACCENT  | ^e  e^  e>                |
| EB | 235 |  | SMALL E WITH DIAERESIS          | "e  e"                    |
| EC | 236 |  | SMALL I WITH GRAVE ACCENT       | `i  i`                    |
| ED | 237 |  | SMALL I WITH ACUTE ACCENT       | 'i  i'                    |
| EE | 238 |  | SMALL I WITH CIRCUMFLEX ACCENT  | ^i  i^  i>                |
| EF | 239 |  | SMALL I WITH DIAERESIS          | "i  i"                    |
| F0 | 240 |  | SMALL ETH                       | d-                        |
| F1 | 241 |  | SMALL N WITH TILDE              | ~n  n~  n-                |
| F2 | 242 |  | SMALL O WITH GRAVE ACCENT       | `o  o`                    |
| F3 | 243 |  | SMALL O WITH ACUTE ACCENT       | 'o  o'                    |
| F4 | 244 |  | SMALL O WITH CIRCUMFLEX ACCENT  | ^o  o^  o>                |
| F5 | 245 |  | SMALL O WITH TILDE              | ~o  o~  o-                |
| F6 | 246 |  | SMALL O WITH DIAERESIS          | "o  o"                    |
| F7 | 247 |  | DIVISION SIGN                   | -:  :-                    |
| F8 | 248 |  | SMALL O WITH OBLIQUE BAR        | /o  o/                    |
| F9 | 249 |  | SMALL U WITH GRAVE ACCENT       | `u  u`                    |
| FA | 250 |  | SMALL U WITH ACUTE ACCENT       | 'u  u'                    |
| FB | 251 |  | SMALL U WITH CIRCUMFLEX ACCENT  | ^u  u^  u>                |
| FC | 252 |  | SMALL U WITH DIAERESIS          | "u  u"                    |
| FD | 253 |  | SMALL Y WITH ACUTE ACCENT       | 'y  y'                    |
| FE | 254 |  | SMALL THORN                     | p   th  |p                |
| FF | 255 |  | SMALL Y WITH DIAERESIS          | "y  y"                    |
+----+-----+---+---------------------------------+---------------------------+
