/* -*- coding: cp852 -*- */
/** Listen Test
 * by Tomasz Zbroek
 * PUBLIC DOMAIN
 */

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <conio.h>
#include <netinet/in.h>
#include <sys/socket.h>

#define BUFFER_SIZE 2048

void errorlog(char *i_pName)
{
  FILE *fp;
  int nErrNo = errno;
  fp = fopen("listen.log","a");
  if(fp != NULL)
    {
      fprintf(fp, "%s, errno=%d, %s\n", i_pName, nErrNo, sock_strerror(nErrNo));
      fclose(fp);
    }
}

int Test(const char *i_pAddr, const char *i_pPort)
{
  int nRes;
  int nSocket = 0;
  int nNewSocket = 0;
  char szHost[254];
  struct sockaddr_in sAddr;

  nSocket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
  if(nSocket < 0)
    {
      errorlog("socket");
      return 0;
    }

  gethostname(szHost, 254);
  
  printf("TCP Port      : %s\n", i_pPort);
  printf("Host name     : %s\n", szHost);

  memset((void *) &sAddr, 0, sizeof(sAddr));
  sAddr.sin_family = AF_INET;
  sAddr.sin_addr.s_addr = INADDR_ANY;
  sAddr.sin_port = htons(atoi(i_pPort)); 
  
  nRes = bind(nSocket, &sAddr, sizeof(sAddr));
  if(nRes < 0)
    {                                                                   
      errorlog("bind");
      close_socket(nSocket);
      return 0;
    }

  nRes = listen(nSocket, SOMAXCONN);
  if(nRes < 0)
    {
      errorlog("listen");
      close_socket(nSocket);
      return 0;
    }

  {
    struct sockaddr_in sRemote;
    int nAddrLen = sizeof sRemote;
    nNewSocket = accept(
                        nSocket,
                        (struct sockaddr*)&sRemote, 
                        &nAddrLen
                        );

    if(nNewSocket < 0)
      {
        errorlog("accept");
        close_socket(nSocket);
        return 0;
      }

    printf("New connection: %s:%d\n", 
           inet_ntoa(sRemote.sin_addr), 
           ntohs(sRemote.sin_port)
           );

  }

  while (!kbhit())
    {
      int nIoctlData = 0; // received data length
      nRes = ioctl(nNewSocket, FIONREAD, &nIoctlData);
      if (nRes < 0)
        {
          errorlog("ioctl");
          close_socket(nNewSocket);
          close_socket(nSocket);
          return 0;
        }
      if (nIoctlData == 0)
        {
          // no data received
          //break;
        }
      else if(nIoctlData > 0)
        {
          unsigned char aBuffer[BUFFER_SIZE];

          if(nIoctlData > BUFFER_SIZE)
            nIoctlData = BUFFER_SIZE;

          nRes = recv(nNewSocket, (char *) &aBuffer, nIoctlData, 0);
          if(nRes == -1)
            {
              errorlog("recv");
              close_socket(nNewSocket);
              close_socket(nSocket);
              return 0;
            }
          else
            {
              aBuffer[nRes] = 0;
              printf("received: %s\n", aBuffer);

              {
                const char aMsg[] = "Hello from DJGPP!";
                nRes = send(nNewSocket, (char *) aMsg, strlen(aMsg), 0);
                if(nRes < 0)
                  {
                    errorlog("send");
                    close_socket(nNewSocket);
                    close_socket(nSocket);
                    return 0;
                  }
              }

            }
        }
    }

  close_socket(nNewSocket);
  close_socket(nSocket);
  
  return 0;
}

int main(int argc, char *argv[])
{
  int nRes;

  const char aPort[] = "23";
  const char aAddr[] = "192.168.0.49";

  const char *pPort = NULL;
  const char *pAddr = NULL;

  if(argc > 1)
    pPort = argv[1];
  if(argc > 2)
    pAddr = argv[2];
  
  printf("Listen Test for DJGPP MSClient wrapper\n");
  if(argc > 1) 
    if(strcmp(argv[1], "-h")==0)
      {
        printf("listen.exe <PORT> <ADDRESS>\n\n");
        return 0;
      }

  if(pPort == NULL)
    pPort = aPort;
  if(pAddr == NULL)
    pAddr = aAddr;

  Test(pAddr, pPort);

  return 0;
}

