#ifndef _BASICMACROS_H_
#define _BASICMACROS_H_

#include "bastypes.h"

#ifndef NULL
#ifdef __cplusplus
#define NULL 0
#else
#define NULL ((void*)0)
#endif
#endif
#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif

#ifndef LOBYTE
 #define LOBYTE(w)           ( (byte)(w) )
#endif

#ifndef HIBYTE
 #define HIBYTE(w)           ( (byte)( ((uint)(w) >> 8) & 0xFF ) )
#endif

#ifndef LOWORD
 #define LOWORD(l)           ( (word)(dword)(l) )
#endif

#ifndef HIWORD
 #define HIWORD(l)           ( (word)( ( ((dword)(l)) >> 16 ) & 0xFFFF ) )
#endif

#ifndef MAKEWORD
 #define MAKEWORD(low, high)  ( (word)( ((byte)(low)) | ( ((word)(high)) << 8 ) ) )
#endif

#ifndef MAKEDWORD
 #define MAKEDWORD(low, high) ((dword)( ((word)(low)) | ( ((dword)((word)(high))) << 16 ) ) )
#endif

//zmiana bin na dec np.: BIN(11000101)
#ifndef BIN
 #define BIN(n) (LOBYTE(LOWORD( (0##n##l % 8 )*0x01 + ((0##n##l/8)%8)*0x02 + \
                ((0##n##l/64)%8)*0x04 + ((0##n##l/512)%8)*0x08 + \
                ((0##n##l/4096)%8)*0x10 + ((0##n##l/32768)%8)*0x20 + \
                ((0##n##l/262144)%8)*0x40 + ((0##n##l/2097152)%8)*0x80)))
#endif//BIN

// zmiana bin na dec np.: BIN2(11000101,11101101)
#define BIN2(low,high) (MAKEINT(BIN(low),BIN(high)))

// konwersja dec<->bcd (1 bajtowe)
#define DEC2BCD(dec) ((((dec)/10)*16) | ((dec) % 10))
#define BCD2DEC(bcd) ((((bcd)/16)*10) + ((bcd) % 16))

// rozmiar tablicy
#define TABLE_SIZE(tbl) (sizeof(tbl)/sizeof(tbl[0]))

#endif
