/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: mbsbtype.c,v 1.2 1996/07/01 19:09:03 jack Exp $ */

#include <mbctype.h>
#include <mbstring.h>

/* us: pointer to string */
/* n: position in string */

int
_mbsbtype (const unsigned char *us, size_t n)
{
  /* position of non-lead character */
  int nln = n;

  /* look for non-lead character */
  while (nln >= 0 && _ismbblead (us[nln]))
    nln--;

  /* non-lead(nln), X..., N(n) */
  /* X... is even characters: N is lead or single */
  /* X... is odd characters: N is trail */
  /* n - nln: X... + 1(N) characters */
  if (((n - nln) & 1) && _ismbblead (us[n]))
    return _MBC_LEAD;

  /* if previous character is lead, next is trail */
  if (n > 0)
    {
      /* previous position */
      int pn = n - 1;

      /* recheck if nln is out of range */
      if (nln > pn)
	{
	  nln = pn;

	  /* look for non-lead character */
	  while (nln >= 0 && _ismbblead (us[nln]))
	    nln--;
	}

      /* exact lead ? */
      if (((pn - nln) & 1) && _ismbblead (us[pn]))
	{
	  /* exact trail ? */
	  if (_ismbbtrail (us[n]))
	    return _MBC_TRAIL;

	  /* otherwise invalid trail character */
	  return _MBC_ILLEGAL;
	}
    }

  /* not lead nor trail */
  if (_ismbbprint (us[n]))
    return _MBC_SINGLE;

  /* control or undefine */
  return _MBC_ILLEGAL;
}
