/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: mbbtype.c,v 1.1 1996/06/23 08:06:41 jack Exp $ */

#include <mbctype.h>
#include <mbstring.h>

/* uc: test character */
/* type: type of previous character */

int
_mbbtype (unsigned char uc, int type)
{
  switch (type)
    {
    case _MBC_LEAD:
      if (_ismbbtrail (uc))
	return _MBC_TRAIL;
      break;

    case _MBC_TRAIL:
    case _MBC_SINGLE:
    case _MBC_ILLEGAL:
      if (_ismbblead (uc))
	return _MBC_LEAD;
      else if (_ismbbprint (uc))
	return _MBC_SINGLE;
      break;
    }

  /* control or undefine */
  return _MBC_ILLEGAL;
}
