/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: wctomb.c,v 1.3 1996/07/09 18:20:15 jack Exp $ */

#include <stdlib.h>
#include <mbprvt.h>

int
wctomb (char *s, wchar_t wchar)
{
  unsigned char *us = (unsigned char *) s;
  int mbc;

  /* Shift-JIS is not state-dependent encoding */
  if (us == 0)
    return 0;

  /* convert to sjis */
  mbc = __wchar_to_mbc (wchar);

  /* check invalid multibyte character */
  if (mbc == _MBC_ERROR_CODE)
    return -1;

  /* multibyte character if high byte is nonzero */
  if ((mbc & 0xff00U) != 0)
    {
      us[0] = (mbc >> 8) & 0x00ffU;
      us[1] = mbc & 0x00ffU;
      return 2;
    }

  /* single byte character */
  us[0] = mbc & 0x00ffU;
  return 1;
}
