/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: wcstombs.c,v 1.2 1996/07/23 14:47:46 jack Exp $ */

#include <stdlib.h>
#include <limits.h>

size_t
wcstombs (char *s, const wchar_t *pwcs, size_t n)
{
  size_t mbn, nn;
  int len;

  /* Shift-JIS is not state-dependent encoding */
  if (s == 0)
    return (size_t) 0;

  /* special case */
  if (pwcs == 0)
    return (size_t) -1;

#if 0
  /* into initial state */
  (void) wctomb (0, (wchar_t) 0);
#endif

  /* not check room size */
  mbn = 0;
  if (n > MB_LEN_MAX)
    {
      for (nn = n - MB_LEN_MAX; mbn < nn; mbn += len)
	{
	  /* convert to multibyte character */
	  len = wctomb (s, *pwcs);
	  if (len < 0)
	    return (size_t) -1;

	  /* EOS ? */
	  if (len == 1 && *s == '\0')
	    return mbn;

	  /* increase for next address */
	  pwcs++;
	  s += len;
	}
    }

  while (1)
    {
      char buf[MB_LEN_MAX];
      char *p;

      /* convert to multibyte character */
      len = wctomb (buf, *pwcs);
      if (len < 0)
	return (size_t) -1;

      /* check room size */
      mbn += len;
      if (mbn > n)
	{
	  mbn -= len;
	  break;
	}

      /* store */
      if (len == 1)
	{
	  /* EOS ? */
	  if ((*s++ = buf[0]) == '\0')
	    return mbn - 1; /* don't count EOS */
	}
      else
	{
	  p = buf;
	  while (--len >= 0)
	    *s++ = *p++;
	}

      /* increase for next address */
      pwcs++;
    }

  return mbn;
}
