/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: mblen.c,v 1.2 1996/06/15 16:22:54 jack Exp $ */

#include <stdlib.h>
#include <mbctype.h>

int
mblen (const char *s, size_t n)
{
  /* Shift-JIS is not state-dependent encoding */
  if (s == 0)
    return 0;

  /* EOS or invalid size */
  if (s[0] == '\0' || n <= 0)
    return 0;

  /* return 1 if s[0] is single byte */
  if (! _ismbblead (s[0]))
    return 1;

  /* Shift-JIS always have two bytes for multibyte charcter */
  if (n >= 2 && s[1] != '\0' && _ismbbtrail (s[1]))
    return 2;

  /* invalid multibyte character */
  return -1;
}
