// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#include <Lib3d/Viewport.H>
#include <Lib3d/ColourRamp.H>
#include <Lib3d/internals/Material.H>

Material::~Material()
{ 
    delete ramp; 
}

void
Material::setParameters(const Vector3 &col,
			float KA, float KD, 
			float C1, float C2, float C3)
{
    colour = col;
    Ka = KA;
    Kd = KD;
    c1 = C1;
    c2 = C2;
    c3 = C3;

    ambient.scale(colour, Ka);
    diffuse.scale(colour, Kd);
}


	 
