#ifndef TexturePipelineClass
#define TexturePipelineClass

#include <Lib3d/Pipeline.H>

class Light;
class Material;
class Texture_VertexNormalData;
class Texture_PolygonData;
class Texture_VertexData;


// Hardwired with an ambient+diffuse, directional-only lighting model.

class TexturePipeline : public Pipeline
{
public:
    TexturePipeline();
    ~TexturePipeline();

    const char *getName() const { return "TexturePipeline"; }

    void registerModel(Model &);
    void render(Model &, 
		Viewport &, 
		const Light *, 
		uint nrLights, 
		uint clipPlanes,
		uint flags);
    
protected:
    void cullBackFaces();
    void transform( Viewport & );
    void renderPolygons( Viewport & );
    void cullAndRenderPolygons( Viewport & );
    bool transformForClipping( Viewport & );
    void clipAndRenderPolygons( Viewport & );
    bool clipPolygon( const Polygon &, uint );


protected:
    typedef void (*ClipFunc)(const Texture_VertexData&, 
			     const Texture_VertexData&, 
			     Texture_VertexData& out );


protected:
    uint thisFrame;
    uint renderFlags;
    bool clip;

    int xmin;
    int xmax;
    int ymin;
    int ymax;
    bool using_lit_normals;
    bool have_backface_info;

    uint sizeNpool;
    Texture_VertexNormalData *npool;

    uint nrVpool;
    uint sizeVpool;
    Texture_VertexData *vpool;

    uint nrPpool;
    uint sizePpool;
    Texture_PolygonData *ppool;

    TexturePipelineData **pv;
    uint clipPlanes;
    uint nrClippedVertices;

protected:
    static void intersectZ1(const Texture_VertexData&, 
			    const Texture_VertexData&, Texture_VertexData&);
    static void intersectZ2(const Texture_VertexData&, 
			    const Texture_VertexData&, Texture_VertexData&);
    static void intersectY1(const Texture_VertexData&, 
			    const Texture_VertexData&, Texture_VertexData&);
    static void intersectY2(const Texture_VertexData&, 
			    const Texture_VertexData&, Texture_VertexData&);
    static void intersectX1(const Texture_VertexData&, 
			    const Texture_VertexData&, Texture_VertexData&);
    static void intersectX2(const Texture_VertexData&, 
			    const Texture_VertexData&, Texture_VertexData&);

    static ClipFunc Intersect[];
};

#endif








