#include <Lib3d/Viewport.H>
#include <Lib3d/Model.H>
#include <Lib3d/WorldBuilder.H>
#include <Lib3d/World.H>
#include <Lib3d/Camera.H>
#include <iostream.h>
#include <fstream.h>

main( int argc, char *argv[] )
{
    if (argc < 2) {
	cerr << "usage: " << *argv << " nff_file1 ..." << endl;
	exit(-1);
    }

    WorldBuilder wb;

    Viewport *viewport = Viewport::create(Device::create(320, 200, 8));
    if (!viewport) {
	cout << "Failed to create viewport" << endl;
	exit(1);
    }

    for (; *++argv ;) {
	cout << "Displaying NFF file: " << *argv << endl;

	ifstream in(*argv);
	if (in.bad()) {
	    cerr << "Couldn't open " << *argv << endl;
	    exit(-1);
	}

	World *world = wb.readNff( in );
	
	if (!world) {
	    cout << "Failed to create scene" << endl;
	    exit(-1);
	}

	cout << "Created object: " << *world << endl;
	
	Matrix34 transform;
	transform.setIdentity();
    
	Matrix34 tmp;
	Matrix34 scale;
	scale.setIdentity();

	// Backwards.
	tmp.setRotation((3.14), 1, 2, 0);
	scale.premul(tmp);
	tmp.setRotation((1.14), 0, 0, 1);
	scale.premul(tmp);
 
	// Object *model = world->getNextNamed("Model");

	cout << "Rendering 400 frames:" << endl;
	for ( int i = 0 ; i < 400 ; i++ ) {
	    //transform.premul(scale);
	    //model->setTransform(transform);
	    world->renderHierarchy( *viewport );
	    viewport->swapBuffers();
	}
	delete world;
    }

    delete viewport;
}










