/****************************************************************************/
/* TPUSHBUT                                                                 */
/*--------------------------------------------------------------------------*/
/* Objet TPushButton (bouton  presser)                                     */
/****************************************************************************/

#ifndef _TPUSHBUT_H_
#define _TPUSHBUT_H_

#include "Types.h"
#include "Keyboard.h"
#include "TObject.h"

// Types des boutons (types cumulables par l'oprateur |)

#define  PB_NORMAL            0
#define  PB_DEFAULT           1  // 000000000001
#define  PB_CANCEL            2  // 000000000010

// Dure d'enfoncement d'un bouton lors de son appui par appel  m_press
// (en ms)

#define PRESSURE_TIME_LENGTH 75

class TPushButton:public TObject
{
  /*-------------*/
  /* Objets amis */
  /*-------------*/

  friend class TWindow;	// Pour que la fentre puisse accder directement
		   				// aux boutons spciaux

  /*------------------*/
  /* Protected fields */
  /*------------------*/

  protected:

    // Shadows

    TShadowChoice f_shadows;


  /*----------------*/
  /* Private fields */
  /*----------------*/

  private:

    // Bouton enfonc ou non

    bool f_pressed;

    // Bouton enfonc par action sur le clavier

    bool f_pressed_by_key;

    //    Bouton actionnable par RETURN
    // et bouton actionnable par ESCAPE

    bool f_ok_button;
    bool f_cancel_button;


  /*--------------------*/
  /* Mthodes publiques */
  /*--------------------*/

  public:

    // Constructeur / Destructeur

		    TPushButton(PObject parent,
				int rel_x,int rel_y,
				int width,
				const char *caption,
				int  type=PB_NORMAL,
				TShadowChoice shadows=SHC_BOTH,
				bool enabled=true);

    virtual	    ~TPushButton();

    // Appui sur le bouton

            void    m_press();


		jptui::CallbackHolder	pressedAction_;
  /*--------------------*/
  /* Mthodes protges */
  /*--------------------*/

  protected:

    // Prise/Perte du focus

    virtual void    m_lose_focus();
    virtual void    m_take_focus();


  /*------------------*/
  /* Mthodes prives */
  /*------------------*/

  private:

    // Affichage

    virtual void    m_display_focus_depending_part();
    virtual void    m_display_caption();

    // Le bouton devient/n'est plus
    // le ok_button ou le cancel_button

	    void    m_take_ok();
	    void    m_lose_ok();
	    void    m_take_cancel() { f_cancel_button=true; };
	    void    m_lose_cancel() { f_cancel_button=false; };

  protected: // Fix: to be able to redefine
    // Evnements

    virtual bool m_left_button_pressed_event(int x,int y);
    virtual bool m_key_pressed_event(TKey key);

};

#endif
