/****************************************************************************/
/* TMENU                                                                    */
/*--------------------------------------------------------------------------*/
/* TMenu class (menus)                                                      */
/****************************************************************************/

#ifndef _TMENU_H_
#define _TMENU_H_

#include "Types.h"

#include "TList.h"


/*ͻ*/
/*                                  TYPES                                 */
/*ͼ*/

// Elment du menu

typedef struct {
  const char *label;
  int attribute;
  int short_cut;
  const char *help_message;
} TMenuItem;


/*ͻ*/
/*                             CLASS DEFINITION                           */
/*ͼ*/


class TMenu:public TList
{
  /*----------------*/
  /* Friend classes */
  /*----------------*/

  friend class TMenuBar;

  /*----------------*/
  /* Private fields */
  /*----------------*/

  private:

    // Menu bar

    PMenuBar            f_menu_bar;

    // Menu number (!= object number)

    int     	        f_menu_nb;

    // The size of the menu needs to be calculated again

    bool 		f_size_to_adjust;

    // Width needed to display shortcuts
    // (only significant if  f_size_to_adjust==false)

    int     		f_short_cut_width;

  /*----------------*/
  /* Public methods */
  /*----------------*/

  public:

    // Constructor / Destructor

    // See TList.h for TMenuItem (m_add_items)

			TMenu(PMenuBar menu_bar,
			      const char *caption,
			      const TMenuItem items[]=NULL,
			      bool enabled=true);
    virtual             ~TMenu();

    // Returns the menu-bar of the menu

	    PMenuBar    m_get_menu_bar() { return(f_menu_bar);};

    // Disables the menu

    virtual void        m_disable();

    // Opens the menu. Returns false if it can't be open

	    bool     m_open();

    // Closes the menu

	    void        m_close();

    // Clicks an item as if the user had clicked it with the mouse,
    // pressed its hotkey...

	    void        m_click_item(int item_index);

    // Add a item to the menu
    // Returns its index or 0 if it couldn't have been added

    virtual int         m_add_item(const char *label, int attribute=LI_NOATTR,
                                   int short_cut = SC_NONE,
                                   const char *help_message = "")
    {return(m_insert_item(0,label,attribute,short_cut,help_message));};
    virtual int         m_insert_item(int index, const char *label, 
                                      int attribute = LI_NOATTR,
                                      int short_cut = SC_NONE,
                                      const char *help_message= "");

    // Add severals items to the menu
    // Each item is of type TListItem
    // For the last item, item[].label must be NULL

    // Returns the number of items really added

    virtual int         m_add_items(const TMenuItem items[]);

    // Deletes items

    virtual void        m_delete_item(int item_index);
    virtual void        m_clear_list();

    // Callback invoked when an item of the menu is clicked
	jptui::CallbackHolder	itemClickedAction_;

  /*-------------------*/
  /* Protected methods */
  /*-------------------*/

  protected:

    // Display routines

    virtual void        m_display();

    // Callbacks

    virtual void        m_selected_item_changed_callback();
    virtual void        m_nb_items_changed_callback();
    virtual void        m_item_clicked_callback(int item_index);

    // Events

    virtual bool     m_short_cut_pressed_event(int shortcut);


  /*-----------------*/
  /* Private methods */
  /*-----------------*/

  private:

    // Display routines

      virtual void      m_display_item_node_label(PItemNode node,bool show_hot_key);

    // Changes the size of the menu so that all its items can be seen

	    void        m_adjust_size();

    // Events

    virtual bool     m_leave_event_if_mouse_leave_list(int x,int y);
    virtual void        m_item_hot_key_pressed_event(int item_index);


};

#endif
