/****************************************************************************/
/* SCREEN                                                                   */
/*--------------------------------------------------------------------------*/
/* Screen functions							    */
/****************************************************************************/

#ifndef _SCREEN_H_
#define _SCREEN_H_

#include "Types.h"

#include "Settings.h"

/*ͻ*/
/*                                   TYPES                                */
/*ͼ*/

// Text mode

typedef enum {TEXTMODE_USER,

	      TEXTMODE_80x25_8,
	      TEXTMODE_80x25_9,
	      TEXTMODE_80x28_8,
	      TEXTMODE_80x28_9,
	      TEXTMODE_80x50_8,
	      TEXTMODE_80x50_9}
	      TTextMode;

// Font

typedef enum {FONT_STANDARD=0,
	      FONT_JPTUI}
	      TFont;


/*ͻ*/
/*                                CONSTANTES                              */
/*ͼ*/

// Background color

#define SCREEN_BACKGROUND      ((DARKGRAY<<4)+(unsigned)BLACK)

// Special graphical characters used by JPTUI

#define CHAR_UP_LEFT_CORNER      ''  // 216
#define TEXT_UP_LEFT_CORNER      ""  // 216

#define CHAR_UP_HLINE            ''  // 195
#define TEXT_UP_HLINE            ""  // 195

#define CHAR_UP_RIGHT_CORNER     ''  // 193
#define TEXT_UP_RIGHT_CORNER     ""  // 193

#define CHAR_MIDDLE_RIGHT_CORNER ''  // 217
#define TEXT_MIDDLE_RIGHT_CORNER ""  // 217

#define CHAR_LEFT_VLINE          ''  // 180
#define TEXT_LEFT_VLINE          ""  // 180

#define CHAR_RIGHT_VLINE         ''  // 194
#define TEXT_RIGHT_VLINE         ""  // 194

#define CHAR_BOTTOM_LEFT_CORNER  ''  // 192
#define TEXT_BOTTOM_LEFT_CORNER  ""  // 192

#define CHAR_BOTTOM_HLINE        ''  // 197
#define TEXT_BOTTOM_HLINE        ""  // 197

#define CHAR_BOTTOM_RIGHT_CORNER ''  // 212
#define TEXT_BOTTOM_RIGHT_CORNER ""  // 212

#define CHAR_TICK		 ''  // 158
#define TEXT_TICK		 ""

#define TEXT_ARROW_UP            ""
#define TEXT_ARROW_DOWN          ""
#define TEXT_ARROW_LEFT          ""
#define TEXT_ARROW_RIGHT         ""

#define TEXT_CLOSE_BUTTON        ""

#define TEXT_CHECKED_RADIO_BUTTON    "ֶ "
#define TEXT_UNCHECKED_RADIO_BUTTON  "յ "

#define TEXT_CHECKED_CHECK_BOX       "ݽ "
#define TEXT_UNCHECKED_CHECK_BOX     "޾ "

#define CHAR_UP_BOTTOM_HLINES    ''  // 215
#define TEXT_UP_BOTTOM_HLINES    ""  // 215

#define CHAR_ALT_UP_LEFT_CORNER  ''  // 218

#define ADDON_CHAR_UP_LEFT_CORNER ''  // looks as  218 - really 242
#define ADDON_TEXT_UP_LEFT_CORNER "" 

#define ADDON_CHAR_UP_HLINE      ''  // looks as  195 - really 243
#define ADDON_TEXT_UP_HLINE      "" 

#define ADDON_CHAR_BOTTOM_LEFT_CORNER	''  // looks like  192 - really 244 
#define ADDON_TEXT_BOTTOM_LEFT_CORNER   ""
                                                              
#define ADDON_CHAR_MIDDLE_UP_DOUBLE_LINE  ''  // looks like  D0 - really 198
#define ADDON_TEXT_MIDDLE_UP_DOUBLE_LINE  ""

#define ADDON_CHAR_MIDDLE_UP_LINE  ''  // looks like  C1 - really 199
#define ADDON_TEXT_MIDDLE_UP_LINE  ""

/*ͻ*/
/*                                 FUNCTIONS                              */
/*ͼ*/

extern int ToScreenChar(int ch);
// Fix: converts all redefined font symbols to '.'

// Waits until the video beams enters retrace mode

void    WaitRetrace();

// Set/Get character definition

void    GetSetCharDefinition(bool set,int nb_chars,char first_char,char *char_definition);

#define DefineChars(nb_chars,first_char,char_definition) GetSetCharDefinition(true,nb_chars,first_char,char_definition)
#define GetCharDefinition(nb_chars,first_char,char_definition) GetSetCharDefinition(false,nb_chars,first_char,char_definition)

// Sets/Returns the text mode used by JPTUI

void      SetTextMode(TTextMode text_mode);
void      SetUserTextMode(void (*set_mode_function)());
TTextMode GetTextMode();

// Returns the size of the screen in characters

int     GetScreenHeight();
int     GetScreenWidth();

// Sets/Returns the font used by JPTUI (standard or not)

void 	  SetFont(TFont font);
TFont	  GetFont();

// Returns the size of the font

int     GetFontHeight();
int     GetFontWidth();

// Initializes and closes the screen

void    InitScreen();
void    CloseScreen();
bool ScreenInitialized();

// - HideScreen temporarily disables the JPTUI screen.
//   Useful to run a DOS program/shell and to switch to graphical mode
// - UnhideScreen redisplays the JPTUI screen after a call to HideScreen()
//
void    HideScreen();
void    UnhideScreen();

// Clears the entire video screen/a rectangular area of the screen
// using character and attribute for the fill character

void    ClearScreen(char attribute,char character);
void    ClearPartOfScreen(int x1,int y1,int x2,int y2,
			  char attribute,char character);

// Copies a rectangular area of a buffer to the screen at (x,y)

void    PartOfBufferToScreen(int x,int y,
			     word *buffer,
			     int x1_part,int y1_part,
			     int part_width,int part_height,
			     int buffer_width);

// Draws a horizontal/vertical shadow

void    HorizontalShadow(int x1,int x2,int y);
void    VerticalShadow(int x,int y1,int y2);

#endif
