/****************************************************************************/
/* KEYBOARD                                                                 */
/*--------------------------------------------------------------------------*/
/* Fonctions de manipulation du clavier                                     */
/****************************************************************************/

#ifndef _KEYBOARD_H_
#define _KEYBOARD_H_

#include "Types.h"

/*ͻ*/
/*                                CONSTANTES                              */
/*ͼ*/


// Codes des caractres non tendus

#define BACKSPACE	    8
#define TAB      	    9
#define RETURN   	   13


#define CTRL_A	            1
#define CTRL_B	 	    2
#define CTRL_C              3
#define CTRL_D              4
#define CTRL_E     	    5
#define CTRL_F              6
#define CTRL_G              7
#define CTRL_H              8
#define CTRL_I              9
#define CTRL_J             10
#define CTRL_K             11
#define CTRL_L             12
#define CTRL_M             13
#define CTRL_N             14
#define CTRL_O             15
#define CTRL_P             16
#define CTRL_Q             17
#define CTRL_R             18
#define CTRL_S             19
#define CTRL_T             20
#define CTRL_U             21
#define CTRL_V             22
#define CTRL_W             23
#define CTRL_X             24
#define CTRL_Y             25
#define CTRL_Z             26
#define ESC	           27

#define SPACE              32

#define CTRL_BACKSPACE    127

#define F1               4155
#define F2               4156
#define F3               4157
#define F4               4158
#define F5               4159
#define F6               4160
#define F7               4161
#define F8               4162
#define F9               4163
#define F10              4164

#define HOME             4167
#define UP               4168
#define PGUP             4169

#define LEFT             4171

#define RIGHT            4173

#define END              4175
#define DOWN             4176
#define PGDN             4177
#define INSERT           4178
#define DELETE           4179

#define F11              4229
#define F12              4230

#define SHIFT_TAB        4879

#define SHIFT_HOME       4935
#define SHIFT_UP         4936
#define SHIFT_PGUP       4937

#define SHIFT_LEFT       4939

#define SHIFT_RIGHT      4941

#define SHIFT_END        4943
#define SHIFT_DOWN       4944
#define SHIFT_PGDN       4945
#define SHIFT_INSERT     4946
#define SHIFT_DELETE     4947
#define SHIFT_F1         4948
#define SHIFT_F2         4949
#define SHIFT_F3         4950
#define SHIFT_F4         4951
#define SHIFT_F5         4952
#define SHIFT_F6         4953
#define SHIFT_F7         4954
#define SHIFT_F8         4955
#define SHIFT_F9         4956
#define SHIFT_F10        4957

#define SHIFT_F11        4999
#define SHIFT_F12        5000

#define CTRL_F1          5214
#define CTRL_F2          5215
#define CTRL_F3          5216
#define CTRL_F4          5217
#define CTRL_F5          5218
#define CTRL_F6          5219
#define CTRL_F7          5220
#define CTRL_F8          5221
#define CTRL_F9          5222
#define CTRL_F10         5223

#define CTRL_LEFT        5235
#define CTRL_RIGHT       5236
#define CTRL_END         5237
#define CTRL_PGDN        5238
#define CTRL_HOME        5239

#define CTRL_PGUP        5252

#define CTRL_F11         5257
#define CTRL_F12         5258

#define CTRL_UP          5261

#define CTRL_DOWN        5265
#define CTRL_INSERT      5266
#define CTRL_DELETE      5267

#define CTRL_SHIFT_LEFT  6003
#define CTRL_SHIFT_RIGHT 6004
#define CTRL_SHIFT_END   6005
#define CTRL_SHIFT_PGDN  6006
#define CTRL_SHIFT_HOME  6007

#define CTRL_SHIFT_PGUP  6020

#define CTRL_SHIFT_UP    6029

#define CTRL_SHIFT_DOWN  6033

#define ALT_BACKSPACE    6158

#define ALT_Q            6160
#define ALT_W            6161
#define ALT_E            6162
#define ALT_R            6163
#define ALT_T            6164
#define ALT_Y            6165
#define ALT_U            6166
#define ALT_I            6167
#define ALT_O            6168
#define ALT_P            6169
#define ALT_A            6174
#define ALT_S            6175
#define ALT_D            6176
#define ALT_F            6177
#define ALT_G            6178
#define ALT_H            6179
#define ALT_J            6180
#define ALT_K            6181
#define ALT_L            6182
#define ALT_Z            6188
#define ALT_X            6189
#define ALT_C            6190
#define ALT_V            6191
#define ALT_B            6192
#define ALT_N            6193
#define ALT_M            6194


#define ALT_F1           6248
#define ALT_F2           6249
#define ALT_F3           6250
#define ALT_F4           6251
#define ALT_F5           6252
#define ALT_F6           6253
#define ALT_F7           6254
#define ALT_F8           6255
#define ALT_F9           6256
#define ALT_F10          6257

#define ALT_1            6264
#define ALT_2            6265
#define ALT_3            6266
#define ALT_4            6267
#define ALT_5            6268
#define ALT_6            6269
#define ALT_7            6270
#define ALT_8            6271
#define ALT_9            6272
#define ALT_0            6273

#define ALT_F11          6283
#define ALT_F12          6284

#define ALT_HOME         6295
#define ALT_UP           6296
#define ALT_PGUP         6297

#define ALT_LEFT         6299

#define ALT_RIGHT        6301

#define ALT_END          6303
#define ALT_DOWN         6304
#define ALT_PGDN         6305

#define ALT_DELETE       6307


/*ͻ*/
/*                                  TYPES                                 */
/*ͼ*/

typedef struct {
  int       character;
  u_char    hot_character;  // Caractre majuscule si non extended
			    // ou caractre accompagn de ALT
} TKey;

/*ͻ*/
/*                                FONCTIONS                               */
/*ͼ*/

// Vide le buffer clavier

void ResetKeyboard();

// Indicates whether a key has been pressed

bool KeyPressed();

// Attend la frappe d'une touche. Retourne la touche frappe

void GetKey(TKey &key);

// Proprits d'une touche

bool IsPrintableKey(TKey key);   // 32  255
bool IsExtendedKey(TKey key);    // >255
bool IsAltKey(TKey key);         // ALT+...

// Obtient/Teste le caractre dit NULL

TKey GetNullKey();
bool IsNullKey(TKey key);

// Attend le relchement de la touche actuellement presse

void WaitKeyRelease();

// Attend un clic du bouton gauche de la souris ou l'appui sur une touche
// Retourne le caractre nul si aucun caractre n'a t frapp
// ou le caractre frapp sinon (cf KEYBOARD.H)

TKey WaitLeftClickOrKeyPressed();

#endif
