/****************************************************************************/
/* FILES                                                                    */
/*--------------------------------------------------------------------------*/
/* File functions							    */
/****************************************************************************/

#ifndef _FILES_H_
#define _FILES_H_

#include "Types.h"

/*ͻ*/
/*                                CONSTANTS                              */
/*ͼ*/

// These constants define the maximal length of the buffers needed to
// hold the differents components of a file name (including the ending \0).

  #ifdef __TCPLUSPLUS__

  #define MAX_PATH   80    // X:\DIR\SUBDIR\FILE.EXT
  #define MAX_DRIVE  3     // X:
  #define MAX_DIR    66    // \DIR\SUBDIR
  #define MAX_FILE   13    // FILE.EXT

  #else

  #define MAX_PATH   261
  #define MAX_DRIVE  3
  #define MAX_DIR    260
  #define MAX_FILE   255

  #endif

// Returns true if the file 'file_name' exists

bool FileExists(const char *file_name);

// Returns the current directory of the current drive

char *GetCurrentDir();

// Returns the full path of a file or directory
// (or the root of the current drive in case of failure)
// full_path must be MAX_PATH bytes length (including /0)
// If a drive is indicated, this drive must exist
// Returns a bool which indicates success or failure

bool FullPath(char *full_path, const char *path);

/* Returns the full path of a file located in the directory of your .exe    */
/* file									    */
/* full_path must be MAX_PATH bytes length (including /0)                   */
/* file_name must be a file_name without directory information              */
/* (if file_name have some directory information, this file name is         */
/* returned unchanged)							    */

void FullPathOfFileInExeDir(char *full_path, const char *file_name);

// Checks whether a drive exists or not
// 0='A', 1='B' ...

bool DriveExists(int drive);

#endif
