#ifndef MNF_JPTUI_BUTTONS_BOX_HPP
#define MNF_JPTUI_BUTTONS_BOX_HPP

#include <memory>
#include "TWindow.h"
#include "TPushBut.h"
#include "Callback.hpp"

namespace jptui {

// Window with buttons at the bottom

class ButtonsBox : public Callback
{
public:
	struct ButtonDescr
	{
		const char*	title_;	// 0 - end of buttons list
	};
	void		init(const char* title, int windowStyle,
				     const ButtonDescr* ds, 
					 int defaultButton = 0, int cancelButton = -1,
					 bool vertical = true,
					 size_t reserveX = 0, size_t reserveY = 0,
					 bool withInfoBar = false);	// reserve.. ignored for vertical
	virtual int	run();	// returns pressed button index
protected:
	static const int	MAX_BUTTONS_NUMBER = 10;
	std::auto_ptr<TWindow>		window_;
	std::auto_ptr<TPushButton>  buttons_[MAX_BUTTONS_NUMBER];
	int	run_;
	virtual void	operator()(TObject* who, what_type what, item_type item);
};

} // namespace jptui

#endif//MNF_JPTUI_BUTTONS_BOX_HPP
