#include <keys.h>

#include <cdesktop.h>

/*

	File:	skeleton.c

	Description:
		Skeleton file for a basic C-Desktop application

      Compile with gcc -o test.exe skeleton.c -lcdesktop

		C-Desktop
		Copyright (C)1998, Brett Porter.

*/

#define  MENU_FILE   0

#define  CMD_EXIT    0

const char  *kConfig_Filename = "CDESKTOP.CFG";

const char	*kCommandDescriptions[] = { "Exit the program" };

void	Desktop_InitialiseMenuBar( T_MenuBar *aMenuBar )
{
	T_MenuObject	*lObject;

   lObject = MenuObject_Initialise( MENU_FILE, "&File" );
   MenuObject_AddMenuItem( lObject, CMD_EXIT, "E&xit", "Alt-X" );
	MenuBar_AddMenuObject( aMenuBar, lObject );

	Event_AddKeyBinding(	K_Alt_X, CMD_EXIT );
}

void	Application_CustomInitialise( void )
{
}

void  Application_CustomTerminate( void )
{
}

void	Application_CustomRegisterConfigVars( void )
{
}

bool	Application_CustomCheckConfigVar( T_ConfigVar *aVar, bool *aRetValPtr )
{
	switch ( aVar->fKey )
	{
		default:
			return false;
	}
	return true;
}

bool    Application_HandleCommand( int aID )
{
	switch ( aID )
	{
		default:
			Error( "Unrecognised command ID in Application_HandleCommand" );
			break;
	}
        return false;
}

void	Application_Idle( void )
{
}

void  Application_CustomRegisterColours( void )
{
}

void  Application_CustomRegisterEventCommands( void )
{
}

int	main( void )
{
	Application_Execute();

	return 0;
}

