#ifndef	__CDESKTOP_MENU_H__
#define	__CDESKTOP_MENU_H__

#include "desktop.h"
#include "dlgobj.h"
#include "group.h"
#include "misc.h"

#ifdef	__cplusplus
extern "C" {
#endif

/*

	menu.h

		Menu system

		C-Desktop
		Copyright (C)1998, Brett Porter.

*/

typedef	struct	S_MenuItem
{
	char	*fName, *fKeyName;
	char	fHotKey;
	bool	fIsLine, fEnabled;
	int	fID, fHotKeyPosition;

	struct S_MenuItem	*fNext;
} T_MenuItem;

typedef struct
{
	DECLARE_DESKTOP_OBJECT;

	int	fID, fMaxKeyNameLength, fMaxNameLength, fNumItems, fHotKeyPosition, fSelected;
	bool	fEnabled;
	char	*fName;
	char	fHotKey;

	T_MenuItem	*fMenuItemList;
} T_MenuObject;

typedef struct
{
	DECLARE_DESKTOP_OBJECT;

	T_Group	*fGroup;

	int	fCurXPos;
} T_MenuBar;

extern	T_MenuObject	*MenuObject_Initialise( int aID, const char *aName );
extern	void		MenuObject_AddMenuItem( T_MenuObject *aObject, int aID, const char *aName, const char *aKeyName );
extern	void		MenuObject_AddLine( T_MenuObject *aObject );

extern	T_MenuBar	*MenuBar_Initialise( int aX1, int aY1, int aX2, int aY2 );
extern	void		MenuBar_EnableCommand( T_MenuBar *aMenuBar, int aID, bool aEnabled );
extern	void		MenuBar_AddMenuObject( T_MenuBar *aMenuBar, T_MenuObject *aObject );

#ifdef	__cplusplus
}
#endif

#endif

