#ifndef	__CDESKTOP_EVENT_H__
#define	__CDESKTOP_EVENT_H__

#include "buffer.h"

#ifdef	__cplusplus
extern "C" {
#endif

/*

	event.h

		Handles the	events.

		C-Desktop
		Copyright (C)1998, Brett Porter.

*/

/*
	PREDEFINED COMMANDS
*/

#define	CMD_EXIT				0

/*
	EVENT TYPES
*/

typedef	enum	{
	EVENT_LEFTMOUSECLICK,
	EVENT_RIGHTMOUSECLICK,
	EVENT_KEYPRESS,
	EVENT_FOCUS,
	EVENT_UNFOCUS,
	EVENT_CANFOCUS,
	EVENT_KILL,
	EVENT_DRAW,
	EVENT_COMMANDENABLED,
	EVENT_SHOW,
	EVENT_HIDE,
}	E_EventType;

/*
	MESSAGES
*/

typedef	enum	{
	MSG_CLOSEMODAL
}	E_MessageType;

/*
	STRUCTURE DEFINITIONS
*/

typedef struct
{
	int	fX, fY;	/*	position within buffer */

	T_Buffer	*fBuffer;
} T_EventDrawParameters;

typedef struct	S_EventRec
{
	E_EventType	fMessage;

	union
	{
		struct
		{
			int	fColumn;
			int	fRow;
		} fMouseClick;

		int	fKeypress;

		T_EventDrawParameters	fDrawParams;

		struct
		{
			int	fID;
			bool	fEnabled;
		} fCommandStatus;

	} fParameters;
} T_EventRec;

/*
	FUNCTION	PROTOTYPES
*/

extern	bool	Event_CheckMessage( E_MessageType aMessage );
extern	void	Event_HandleLeftMousePress( int aColumn, int aRow );
extern	void	Event_HandleRightMousePress( int aColumn, int aRow );
extern	void	Event_HandleKeypress( int aKeypress );
extern	void	Event_HandleCommand( int aID );
extern	void	Event_Initialise( void );
extern	void	Event_EnableCommand( int aID, bool aEnabled );
extern	void	Event_CheckCommands( void );
extern	void	Event_AddKeyBinding( int aKey, int aCommand );
extern	void	Event_RegisterCommand( int aID );
extern	void	Event_SendMessage( E_MessageType aMessage );

#ifdef	__cplusplus
}
#endif

#endif



