#include <conio.h>
#include <ctype.h>
#include <keys.h>
#include <stdio.h>

#include "appl.h"
#include "buffer.h"
#include "colour.h"
#include "desktop.h"
#include "dialog.h"
#include "dlgobj.h"
#include "error.h"
#include "event.h"
#include "input.h"

/*

	dialog.c

		Dialog box

		C-Desktop
		Copyright (C)1998, Brett Porter.

*/

/*
	FUNCTION	PROTOTYPES
*/

static	void	Dialog_DrawFrame( T_Dialog *aDialog, T_EventDrawParameters *aParams );

/*
	FUNCTION DEFINITIONS
*/

T_Dialog	*Dialog_Initialise( const char *aTitle, int aX1, int aY1, int aX2, int aY2, int aFlags,
									  bool ( *aEventHandler )( void*, T_EventRec* ))
{
	T_Dialog	*lDialog;

	P_InitVar( lDialog, T_Dialog );

	lDialog->fGroup = Group_Initialise( aX1, aY1, aX2, aY2, aFlags );

	P_CreateStr( lDialog->fTitle, aTitle );

	DesktopObj_Initialise( lDialog, aEventHandler, false );

	return lDialog;
}

void	Dialog_Kill( T_Dialog *aDialog )
{
	free( aDialog->fTitle );
	Group_Kill( aDialog->fGroup );
	free( aDialog );
}

int	Dialog_ShowModal( T_Dialog *aDialog )
{
	T_Group	*lGroup = aDialog->fGroup;

	Group_AddObject( gEvent_ModalGroup, aDialog, lGroup->fX1, lGroup->fY1, lGroup->fX2, lGroup->fY2, lGroup->fFlags );

	Group_GoModal( lGroup );

	Group_RemoveObject( gEvent_ModalGroup, aDialog );

	return aDialog->fGroup->fCloseModalCommand;
}

void	Dialog_DrawFrame( T_Dialog *aDialog, T_EventDrawParameters *aParams )
{
	T_Buffer	*lBuffer = aParams->fBuffer;
	T_ObjectRec	*lRec;
	char		lStr[81];
	int		lWidth, lHeight, i;
	int		lX1, lY1, lX2, lY2;

	lWidth =	aDialog->fGroup->fX2-aDialog->fGroup->fX1+1;
	lHeight = aDialog->fGroup->fY2-aDialog->fGroup->fY1+1;

	lX1 = aParams->fX;
	lY1 = aParams->fY;
	lX2 = lX1+lWidth-1;
	lY2 = lY1+lHeight-1;

	lStr[lWidth] = EOS;
	memset( lStr, '', lWidth );
	lStr[0] = '';
	lStr[lWidth-1] = '';
	Buffer_Print( lBuffer, lX1, lY1, lX2, lY1, lStr, COLOUR_DIALOG_FRAME );

	sprintf( lStr, " %s ", aDialog->fTitle );
	Buffer_Print( lBuffer, lX1+2, lY1, lX2, lY1, lStr, COLOUR_DIALOG_FRAME );

	if ( !( aDialog->fGroup->fFlags & FLAG_NOCLOSEBUTTON ))	/// just add the object, easier
	{
		Buffer_Print( lBuffer, lX2-4, lY1, lX2-2, lY1, "[X]", COLOUR_DIALOG_FRAME );
	}

	memset( lStr, '', lWidth );
	lStr[0] = '';
	lStr[lWidth-1] = '';
	Buffer_Print( lBuffer, lX1, lY2, lX2, lY2, lStr, COLOUR_DIALOG_FRAME );

	lStr[lWidth-2] = EOS;
	for ( i = lHeight-2; i--; )
	{
		sprintf( lStr, "%*s", lWidth-2, "" );
		Buffer_Print( lBuffer, lX1, lY1+i+1, lX2, lY1+i+1, lStr, COLOUR_DIALOG_FRAME );
	}
	if ( aDialog->fGroup->fVisible )
	{
		lRec = aDialog->fGroup->fObjectList;
		while ( lRec != NULL )
		{
			DesktopObj_Draw( lRec, aDialog->fGroup->fX1-lX1, aDialog->fGroup->fY1-lY1, lBuffer );
			lRec = lRec->fNext;
		}
	}
}

void	Dialog_FocusObject( T_Dialog *aDialog, void *aObject )
{
	Group_FocusObject( aDialog->fGroup, aObject );
}

bool	Dialog_DefaultEventHandler( void *aDialog, T_EventRec *aEvent )
{
	bool	lRetVal = false;

	T_Dialog	*lDialog = aDialog;

	switch ( aEvent->fMessage )
	{
		case	EVENT_KILL:
			/* must do the kill explicitly, so don't call Dialog_Kill here */
			lRetVal = true;
			break;
		case	EVENT_DRAW:
			Dialog_DrawFrame( lDialog, &aEvent->fParameters.fDrawParams );
			lRetVal = true;
			break;
		case	EVENT_CANFOCUS:
			break;
		case	EVENT_SHOW:
			/// should this do something? Pass it on?
			break;
		default:
			FatalError( "Unhandled message" );
			break;
	}
	return lRetVal;
}



