#ifndef	__CDESKTOP_DESKTOP_H__
#define	__CDESKTOP_DESKTOP_H__

#include "buffer.h"
#include "dlgobj.h"

#ifdef	__cplusplus
extern "C" {
#endif

/*

	desktop.h

		Desktop stuff

		C-Desktop
		Copyright (C)1998, Brett Porter.

*/

/*
	STRUCTURE DEFINITIONS
*/

typedef struct	S_ObjectRec
{
	int	fFlags, fX1, fY1, fX2, fY2;	/* offsets inside the group */

	union
	{
		void	*fData;

		T_MinimumDesktopObject	*fHeader;
	} fObject;

	struct S_ObjectRec	*fNext;
	struct S_Group			*fOwner;
} T_ObjectRec;

/*
	FUNCTION	PROTOTYPES
*/

extern	void		Desktop_Initialise( void );
extern	void		Desktop_HandleLeftMousePress( int aColumn, int aRow );
extern	void		Desktop_HandleRightMousePress( int aColumn, int aRow );
extern	void		Desktop_HandleKeypress( int aKeypress );

extern	inline	void	Desktop_SetStatusString( const char *aString );

extern	void	DesktopObj_Initialise( void *aObject, bool ( *aEventHandler )( void*, T_EventRec* ), bool aCanActivate );
extern	bool	DesktopObj_HandleLeftClick( T_ObjectRec *aObject, int aColumn, int aRow );
extern	bool	DesktopObj_HandleRightClick( T_ObjectRec *aObject, int aColumn, int aRow );
extern	bool	DesktopObj_HandleKeypress( T_ObjectRec *aObject, int aKeypress );
extern	void	DesktopObj_Draw( T_ObjectRec *aObject, int aX, int aY, T_Buffer *aBuffer );
extern	bool	DesktopObj_CanFocus( T_ObjectRec *aObject );
extern	bool	DesktopObj_Focus( T_ObjectRec *aObject );
extern	void	DesktopObj_Kill( T_ObjectRec *aObject );

/*
	FLAGS
*/

#define	FLAG_NONE				0
#define	FLAG_CENTREX			BITMASK0
#define	FLAG_CENTREY			BITMASK1
#define	FLAG_NOCLOSEBUTTON	BITMASK2

#define	FLAG_CENTRE				FLAG_CENTREX | FLAG_CENTREY

/*
	EXTERNAL VARIABLES
*/

extern	struct S_Group	*gDesktop;

#ifdef	__cplusplus
}
#endif

#endif




