/*
 ** BETATRON high level library for platform and action arcade games.
 ** Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
 **
 ** PLVGA.H: This file is part of the BETATRON library and can be used
 **          and/or distributed only under the terms of the GNU Library
 **          General Public License. See doc/readme.1st for details.
 */


#ifndef plvga_h
#define plvga_h

extern "C" char pl_is386();
char pl_isvga();
extern "C"  void pl_memsetw(void *data,short value, long len);
extern "C" char pl_iswindows();
extern "C" void mx320x200(unsigned char linesize);

char *pl_rawto4planes(char *inmap,unsigned short len,unsigned short hei);
char *pl_4planes2raw(char *map,unsigned short len,unsigned short hei);

char *pl_tile4planes2raw(char *intile,char * &outtile);
char *pl_tilerawto4planes(char *intile,char * &outtile);

char *pl_raw2rle(char *raw,unsigned short l,unsigned short h);
char *pl_rle2raw(char *rle,unsigned short l,unsigned short h);

extern "C" void  pl_horline(short x,short y,short len,char color,void *buf,
				 unsigned short buflen);
extern "C" void  pl_verline(short x,short y,short hei,char color,void *buf,
				 unsigned short buflen);
void pl_line(short x1,short y1,short x2, short y2,
				 char  color ,char *buf,unsigned short buflen);
extern "C" void pl_thruclip(char *fromp,unsigned short l,unsigned short clipl,
				 unsigned short cliph,unsigned short sx,
				 unsigned short sy, unsigned short tox,
				 unsigned short toy, char *buf,
				 unsigned short buflen);
extern "C" void pl_solidclip(char *fromp,unsigned short l,unsigned short clipl,
				 unsigned short cliph,unsigned short sx,
				 unsigned short sy, unsigned short tox,
				 unsigned short toy, char *buf,
				 unsigned short buflen);


void pl_setpal(char *PPalette);
void pl_setvideomode(unsigned char mode);
void pl_setstartadr(long adrs);



void pl_retrace();
void pl_sethorpel(unsigned char value);
extern "C" void pl_setRGBcolor(unsigned char color,char R,char G,char B);
void pl_getRGBcolor(unsigned char i,char &R,char &G,char &B);


#define Mpl_pixel(Mx,My,Mcolor,Mbuf,Mbuflen)   \
{  long buflen= (Mbuflen);					   \
   long y=(My), x=(Mx); 					  \
   char *buf = (Mbuf);						   \
   char color=Mcolor;						   \
asm("                                   \n \
	mull	%1				#y			\n \
	addl	%2,%%eax		 #x 		 \n \
	movl	%3,%%edi		#buf		\n \
	addl	%%eax,%%edi 				\n \
	movb	%%bl,(%%edi)": :"%eax" (buflen), "m" (y), "m" (x), "m" (buf), \
							"%bl" (color): "%edx","%edi"); \
}

#endif
