/*  Example programs for BETATRON game library. 
 ** Copyright (C) 1997 Liouros Thanasis, liouros@hotmail.com
 **
 ** cloud.cc:   This file is part of the example programs for BETATRON game 
 **             library and can be used and/or distributed only under the terms 
 **             of the GNU General Public License. See doc/examples.txt for 
 **             details.
 */
		
#include "world.h"
#include "cloud.h"



// ----------------------- action function of the thunder -------------------
static void thundergo(TOsprite *o)
{
 // check if we can go down, if not, die in the next frame
 if (o->owner->howfarSD(o,o->dy) < o->dy) o->deletebit=1;
 else // go down
  o->y+=o->dy;
}

// --------------------------------------------------------------------------

#define MAXINT          ((unsigned long)-1L)

static void cloudgo(register TOcloud *o)
{
 unsigned short t;
 TOsprite *thunder;
 register TOworld *w=o->owner;
 unsigned short l,h;


 t=o->owner->dticks;

 if (o->time>t) o->time-=t; else
 {
  // time counter has reached zero , release a thunder
  o->time+=random()/ ( MAXINT /(o->maxtime-o->mintime))+o->mintime;
  thunder = new TOsprite ;
  l=w->framesdescr[o->thunderframe]->len;
  h=w->framesdescr[o->thunderframe]->hei;
  thunder->init(0,o->x+(o->slen >>1),o->y+o->shei,l,h,0);
  thunder->nextaction=(TPaction) thundergo;
  thunder->framenow=o->thunderframe;
  thunder->dy=random() / (MAXINT /2)+1;
  w->addobj(4,thunder,6);
 }

 if ( o->x > o->rightlimit || o->x < o->leftlimit) o->dx=-o->dx;

 o->x+=o->dx;
}



void TOcloud::init(unsigned char id0,unsigned short x0, unsigned short y0,
             signed short framenow0, unsigned short thunderframe0,
             signed char dx0,
             unsigned short leftlimit0, unsigned short rightlimit0)
{
  TOsprite::init(id0,x0,y0,20,15,framenow0);
  nextaction=(TPaction)cloudgo;
  dx=dx0;
  leftlimit=leftlimit0;
  rightlimit=rightlimit0;
  thunderframe=thunderframe0;
  time=0;
  mintime = 657;
  maxtime = 1000;
}
