/*
 ** BETATRON high level library for platform and action arcade games.
 ** Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
 **
 ** CTC.CC: This file is part of the BETATRON library and can be used
 **         and/or distributed only under the terms of the GNU Library
 **         General Public License. See doc/readme.1st for details.
 */



#include <conio.h>
#include <stdio.h>
#include <pc.h>
#include "plvga.h"
#include "ctc.h"
#include <dpmi.h>



CTCtimer::CTCtimer()
{
  oldcounter=counter=0;
  outportb(0x43,0x36);      // counter 0, mode 2
  outportb(0x40,0);
  outportb(0x40,0);         // loadvalue = 0
}



long CTCtimer::getretraceticks()
{
#define CLASSDIVISOR	    1000
#define TIMES		      10
#define RETRACELIMIT	    8000

 unsigned long ticks[TIMES];
 short maxclustersno,clustersno=0;
 short i,j,k;
 long value,maxvalue;
 short oldclass,curclass,maxclass;
 long sum;


 __dpmi_get_and_disable_virtual_interrupt_state();
 pl_retrace();
 startCTC0timer(); 
 pl_retrace();
 ticks[0]=getCTC0elapsed();
 for (i=0;i<TIMES;i++)
 {
   pl_retrace();
   ticks[i]=getCTC0elapsed();
 }
 __dpmi_get_and_enable_virtual_interrupt_state();


 // etoimasou na taksinomiseis ton pinaka
 for (k=TIMES-1;k>=1;k--)
 {
  maxvalue=0L;	    // mia poli mikri timi
  for (j=0;j<=k;j++)
    if (ticks[j] > maxvalue) { maxvalue=ticks[j]; i=j; }
  ticks[i]=ticks[k];
  ticks[k]=maxvalue;
  }
  // taksinomisi egine


  // etoimasou na vreis pou sygkentronontai oi pio polles
  // times. Gia na to kaneis auto xorise tis times se klaseis
  // analoga me tis 1000ades (CLASSDIVISOR). Kai vres
  // tin klasi me tis pio polles times.
  oldclass=0;
  clustersno=0;
  maxclustersno=0;

  for (i=0;i<TIMES;i++)
  {
    value=ticks[i];
    curclass=value / CLASSDIVISOR;
    if (curclass==oldclass) clustersno++;
    else
    {
      if (clustersno>maxclustersno)
      {
       maxclustersno=clustersno;
       maxclass=oldclass;
      }
      oldclass=curclass;
      clustersno=1;
    }
  }

  if (clustersno>maxclustersno)
  {
    maxclustersno=clustersno;
    maxclass=oldclass;
  }


// etoimasou na vreis to proto stoixeio tis klasis me tis pio polles times,
// diladi to mikrotero stoixeio autis tis klasis
 for (i=0;i<TIMES;i++)
  if ( ticks[i] / CLASSDIVISOR == maxclass) break;


// bres to meso oro ton timon
 j=i+maxclustersno;
 for (sum=0;i<j;i++)
 {
  sum+=ticks[i];
  }

  sum/=maxclustersno;
  return sum;
}



