#
# BETATRON high level library for platform and action arcade games.
# Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
#
# SCLIP.S: This file is part of the BETATRON library and can be used
#          and/or distributed only under the terms of the GNU Library
#          General Public License. See doc/readme.1st for details.
#



.extern _pl_a000h
.globl	_M2Vsolidclipspr
# memory to video solid clipped sprite

#/*
#-----------------------------------------------------------------------------
#extern "C" void  M2Vsolidclipspr(char *spr,unsigned short pagetar,unsigned short vx,
#			     ,unsigned short vy,unsigned short len,unsigned short hei
#			     ,unsigned short sprx,unsigned short spry
#			     ,unsigned short totallen,unsigned short totalhei);
#
# opou:
# spr:	       deiktis stin arxi mias eggrafis tipou Tsprframes
# pagetar:     target page offset
# vx:	       sintetagmeni x sti video memory
# vy:	       sintetagmeni y sti video memory
# len:	       to platos toy tmimatos toy sprite pou tha emfanisthei,
#	       mporei na einai to poli iso me to mikos tou sprite frame
# hei:	       to ipsos tou tmimatos tou sprite pou tha emfanisthei
# sprx,spry:   i apomakrinsi apo tin arxi ton dedomenon tou sprite frame
#	       apo opou tha arxisei i emfanisi tou sprite
# totallen,totalhei sinolikes diastaseis tou sprite
#-----------------------------------------------------------------------------
#*/

.equ	    savedebp0	 ,   0
.equ	    retadr0	 ,   4
.equ	    spr0	 ,   8
.equ	    pagetar0	 ,   12
.equ	    vx0 	 ,   16
.equ	    vy0 	 ,   20
.equ	    len0	 ,   24
.equ	    hei0	 ,   28
.equ	    sprx0	 ,   32
.equ	    spry0	 ,   36
.equ	    totallen0	 ,   40
.equ	    totalhei0	 ,   44




_M2Vsolidclipspr:


#[bp-4]:      len div 4
#[bp-6]:      video offset
#[bp-8]:
#[bp-10]:     mikos grammis sigkekrimenou  bitplane
#[bp-12]:      ⥞  ⢤  sequencer controller
#[bp-14]:     arithmos epanalipseon kirios broxou
#[bp-16]:     len mod 4
#[bp-18]:       殦
#[bp-20]:      殦 NEWLINE:
#[bp-22]:     bitplane sto sprite
#[bp-24]:     bitplane stin othoni
#[bp-26]:     mikos bytes bitplane ana grammi pou tha tipothoun
#[bp-28]:     torini sintetagmeni xspr
#[bp-30]:     slen mod 4
#[bp-32]:     slen div 4
#[bp-34]:     xspr div 4
#[bp-36]:     shei
#[bp-38]:     bima auksisis tou di
#[bp-40]:
#[bp-42]:     apothikeusi tou cx prosorini
#[bp-46]:     saved esi
#[bp-50];     esi increase step


	pushl	%ebp
	movl	%esp,%ebp
	subl	$54,%esp	 #	   { local vars   }

	pusha
	pushw %es
	mov _pl_a000h,%ax
	mov %ax,%es

	xorl	%ebx,%ebx
	xorl	%ecx,%ecx
	xorl	%eax,%eax
	xorl	%edx,%edx

#;;;;;;;;;;;;;;;;;;;;;;
	xorl	%edi,%edi

	movl	spr0(%ebp),%esi       #spr
	movw	totallen0(%ebp),%ax   #slen (sprite len)
	movw	%ax,%bx
	shrw	$2,%ax
	movw	%ax,-32(%ebp)	#slen div 4
	andw	$0B011,%bx
	movw	%bx,-30(%ebp)	#slen mod 4
	movw	totalhei0(%ebp),%ax   #shei
	movw	%ax,-36(%ebp)

	movl	%esi,-46(%ebp)	#sose ton si


	movw	len0(%ebp),%ax	      #len (mikos tmimatos grammis sprite pou tha ektipothei )
	movw	%ax,%bx
	shrw	$2,%ax
	movw	%ax,-4(%ebp)	# len div 4
	andw	$0B011,%bx	#
	movw	%bx,-16(%ebp)	# len mod 4

	movw	$4,%ax
	movw	%ax,-14(%ebp)	# metritis broxou = 4
	cmpw	$4,len0(%ebp)	# len < 4
	jae	COUNTEREQ4

	movw	len0(%ebp),%ax	      # len
	movw	%ax,-14(%ebp)


COUNTEREQ4:
broxos:
	cmpw	$0,-14(%ebp)   # elegkse metriti
	jne	NOTTELOS
	jmp	TELOS


NOTTELOS:


	movw	sprx0(%ebp),%ax       #sprx
	movw	%ax,%bx
	andw	$0B011,%ax	 #ax=sprx mod 4
	movw	%ax,-22(%ebp)	 #spr bitplane
	shrw	$2,%bx
	movw	%bx,-34(%ebp)	# sprx div 4

	movw	-32(%ebp),%cx	# xrisimopoieitai parakato  DIV

	cmpw	$0,-30(%ebp)   # einai MOD == 0
	je	MODZERO

	movw	-30(%ebp),%ax	# ax =MOD
	cmpw	-22(%ebp),%ax	#  MOD > sprBITPLANE
	ja	MODABOVEsprBIT

	movw	-32(%ebp),%ax		 #ax = DIV
	mulw	-22(%ebp)		 # *sprBITPLANE
	addw	-30(%ebp),%ax		 # + MOD
	mulw	-36(%ebp)		 # * shei
	movw	%ax,%bx 		 # bx= shei(MOD+sprBITPLANE*DIV)
	movw	-32(%ebp),%ax
	mulw	spry0(%ebp)
	addw	-34(%ebp),%ax	#ax=sprx div 4 + spry*DIV
	addw	%ax,%bx 	# bx: dieuthinsi arxis dedomenon
	jmp	GOON

MODABOVEsprBIT:
	incw	%cx	# auksise to DIV sto cx kata 1



MODZERO:
	movw	-36(%ebp),%ax	      # ax = shei
	mulw	 -22(%ebp)	      # ax = sprBITPLANE * shei
	addw	spry0(%ebp),%ax       # + spry
	mulw	%cx		      # * DIV i (*(DIV+1))
	addw	-34(%ebp),%ax	      # ax = DIV(sprBITPLANE*shei+spry)+sprx mod 4
	movw	%ax,%bx 	      # bx = dieuthinsi arxis ton dedomenon

GOON:
	movw	%cx,-10(%ebp)	# mikos grammis sigkekrimenou bitplane


	movl	-46(%ebp),%esi
	addl	%ebx,%esi	# si stin arxi dedomenon pros antigrafi

	movw	-4(%ebp),%cx	# cx:= len div 4
	cmpw	$0,-16(%ebp)	# elegkse an len mod 4 == 0
	je	GOON2
	decw	-16(%ebp)      # meiose len mod 4
	incw	%cx	       # auksise len div 4 ston cx

GOON2:
	movw	%cx,-42(%ebp)

	movw	$88,%ax 	# megethos grammis sti video ram
	subw	%cx,%ax
	movw	%ax,-38(%ebp)	# bima auksisis tou di

	xorl	%eax,%eax
	movw	-10(%ebp),%ax
	subw	%cx,%ax
	movl	%eax,-50(%ebp)	# bima auksisis si

	movw	hei0(%ebp),%ax
	movw	%ax,-20(%ebp)	# metritis broxou line


	movw	$88,%ax
	mulw	vy0(%ebp)     # ax=88*vy
	movw	vx0(%ebp),%bx # bx = vx

	movw	%bx,%cx
	andw	$0B00000011,%cx # cx: = vx mod 4
	movw	%cx,-24(%ebp)	# [bp-24]: = cx =bitplane stin othoni

	shrw	$2,%bx
	addw	%bx,%ax 	# ax= 88*vy + (vx >> 2)
	movw	%ax,-6(%ebp)	# video ofs
	movw	%ax,%di
	addw	pagetar0(%ebp),%di    # prosthese kai ti video page

	movb	$1,%ah
	shlb	%cl,%ah
	movb	$02,%al 	#{ map mask register }
	movw	%ax,-12(%ebp)	#	  { latch:  [bp-12] }
	movw	$0x03c4,%dx	#   seq index
	outw	%ax,%dx 	#   steilta


NEWLINE:
	cmpw	$0,-20(%ebp)	# shei == 0
	je	NEXTPLANE

	movw	-42(%ebp),%cx

	shrw	$1,%cx
	jnc	SKIPMOVSB
	movb (%esi),%al
	movb %al, %es:(%edi)
	incw %di
	incl %esi
SKIPMOVSB:
	shrw	$1,%cx
	jnc	SKIPMOVSW
	movw (%esi),%ax
	movw %ax, %es:(%edi)
	addw $2,%di
	addl $2,%esi
SKIPMOVSW:
	testw  %cx,%cx
	jz  endloop
scliploop:
	movl (%esi),%eax
	movl %eax, %es:(%edi)
	addw  $4,%di
	addl  $4,%esi
	decw  %cx
	testw %cx,%cx
	jnz scliploop
endloop:

	addw	-38(%ebp),%di
	addl	-50(%ebp),%esi

	decw	-20(%ebp)      # meiose shei
	jmp	NEWLINE


NEXTPLANE:
	incw	sprx0(%ebp)		# auksise to sprx
	decw	-14(%ebp)		# meiose metriti kirios broxou
	incw	 vx0(%ebp)		# auksise to vx


	jmp	broxos


TELOS:
	popw	%es
	popa
	addl	$54,%esp
	popl	%ebp
	ret


.END




