#include <stdio.h>
#include <string.h>
#include "mdlib.h"
#include "data.h"

#define TICK    1




// a test program for the MDL lib
int main(int argc, char *argv[])
{
   int dlgcode = 0;
   char *tstring;
   mdl_t model;
   camera_t cam;
   PALLETE pal;
   BITMAP *tmp;
   BITMAP *dbuf;
   BITMAP *logo7;
   SAMPLE *mysamp;
   DATAFILE *mdlibdat;
   pakentry_t *paklist;
   long numfiles;
   unsigned char sample_alloc = 0;
//   char pakname[256] = "f:/quake2/baseq2/pak0.pak";
//   char pakname[256] = "d:/games/quake/id1/pak0.pak";
   char pakname[256] = "c:/";
   char *viewfile;
DIALOG main_dlg[] =
{
   /* (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1)  (d2)  (dp) */
   { d_keyboard_proc,   0,    0,    0,    0,   0,     0,    0,    0,       0,    0,    0 },
   { d_list_proc,       40,   10,   560,  260,  255,  0,    0,    D_EXIT,  0,    0,    PAKListBox },
   { d_button_proc,     60,   420,  120,  20,   255,  0,    'v',  D_EXIT,  0,    0,    "&View" },
   { d_button_proc,     460,  420,  120,  20,   255,  0,    'x',  D_EXIT,  0,    0,    "E&xit" },
   { d_button_proc,     260,  420,  120,  20,   255,  0,    'e',  D_EXIT,  0,    0,    "&Extract" },
   { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
};

   printf("Please wait while loading graphics...\n");

   allegro_init();
   install_keyboard();
   install_mouse();
   install_timer();

   mdlibdat = load_datafile("mdlib.dat");
   if( mdlibdat == NULL )
   {
       printf("Fatal Error: Couldn't find MDLIB.DAT\n");
       exit(1);
   }

   set_config_file("mdlib.cfg");

   // set up sound
   if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, argv[0]) != 0) {
      printf("Error initialising sound system\n%s\n", allegro_error);
      return 1;
   }


   set_gfx_mode( GFX_AUTODETECT, 640, 480, 0, 0 );
   set_projection_viewport(0, 0, SCREEN_W, SCREEN_H);


   // create a double buffer
   dbuf = create_bitmap(SCREEN_W, SCREEN_H);
   clear( dbuf );


   logo7 = mdlibdat[LOGO7_BMP].dat;
   stretch_blit(logo7, screen, 0, 0, logo7->w, logo7->h, 0, 0, SCREEN_W, SCREEN_H/2);
   stretch_blit(logo7, screen, 0, 0, logo7->w, logo7->h, 0, SCREEN_H/2, SCREEN_W, SCREEN_H/2);
   set_pallete( mdlibdat[LOGO7_PAL].dat );
   show_mouse( screen );


   strcpy(pakname, get_config_string(NULL, "pak_path", "c:/"));
   if( !file_select("Select a PAK file", pakname, "pak") ) exit(1);
   set_config_string(NULL, "pak_path", pakname);


   // load the pak
   paklist = PAKLoadDir(pakname, &numfiles);

   // do main dialog cicle until the user press Exit
   while(dlgcode != 3)
   {
      // clear the screen and show the logo
      clear(screen);
      stretch_blit(logo7, screen, 0, 0, logo7->w, logo7->h, 0, SCREEN_H/2, SCREEN_W, SCREEN_H/2);

      dlgcode = do_dialog( main_dlg, 1 );
      if(dlgcode == -1) break; // exit on Esc
      if(dlgcode == 4)
      {
            PAKExtractFile(pakname, paklist[ main_dlg[1].d1 ]);
            alert("File extracted to current directory.", NULL, NULL, "Ok", NULL, 'o', 0);
      }
      if(dlgcode == 1 || dlgcode == 2) // do something if the user press View/Extract or an item
      {
         clear(screen);

         tstring = get_extension( paklist[ main_dlg[1].d1 ].filename );
         viewfile = strlwr(get_filename( paklist[ main_dlg[1].d1 ].filename ));

         // if it is an image, display it
         if( !strcmp(tstring, "pcx") || !strcmp(tstring, "tga") || !strcmp(tstring, "bmp"))
         {
            PAKExtractFile(pakname, paklist[ main_dlg[1].d1 ]);
            tmp = load_bitmap( viewfile , pal);

            set_pallete( pal );
            blit(tmp, screen, 0, 0, 0, 0, tmp->w, tmp->h);
            readkey();

            set_pallete( mdlibdat[LOGO7_PAL].dat );
            destroy_bitmap( tmp );
            remove( viewfile ); // delete the file
         }

         // if it is a sound, play it
         if( !strcmp(tstring, "wav") )
         {
            PAKExtractFile(pakname, paklist[ main_dlg[1].d1 ]);
            if(sample_alloc) { destroy_sample( mysamp ); sample_alloc = 0; }
            mysamp = load_sample( viewfile );

            play_sample( mysamp, 250, 128, 1000, 0);
            sample_alloc = 1;

            remove( viewfile ); // delete the file
         }

         // if it is a model, rotate it
         if( !strcmp(tstring, "mdl") || !strcmp(tstring, "md2") )
         {
            PAKExtractFile(pakname, paklist[ main_dlg[1].d1 ]);

            // if it is a Q2 model we must extract the skin also
            // ATTENTION: the skin must be the next item on the list
            // FIX ME!
            if(!strcmp(tstring, "md2"))
               PAKExtractFile(pakname, paklist[ main_dlg[1].d1+1 ]);

            model = MDLLoad( viewfile );

            if(model.type == TYPE_MDLQ1) set_pallete( mdlibdat[Q1_PAL].dat );
            if(model.type == TYPE_MDLQ2) set_pallete( mdlibdat[Q2_PAL].dat );

            clear_keybuf();

            // init the camera
            cam = CameraFixed(0., -10., -60., 0., 0., 0.);

            while( !key[KEY_SPACE] )
            {

               MDLUpdateView( cam, &model );
//               MDLDrawPoints( dbuf, &model );
//               MDLDrawWireframe( dbuf, &model );
               MDLDrawTexture( dbuf, &model );

               blit( dbuf, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H );
               clear( dbuf );

               if(key[KEY_UP]) cam.pitch += TICK;
               if(key[KEY_DOWN]) cam.pitch -= TICK;
               if(key[KEY_LEFT]) cam.roll += TICK;
               if(key[KEY_RIGHT]) cam.roll -= TICK;
               if(key[KEY_Z]) cam.z--;
               if(key[KEY_A]) cam.z++;
               if(key[KEY_S]) cam.head -= TICK;
               if(key[KEY_X]) cam.head += TICK;
               if(key[KEY_PLUS_PAD]) if(model.frameidx<model.numframes-1) model.frameidx++;
               if(key[KEY_MINUS_PAD]) if(model.frameidx>0) model.frameidx--;
               if(key[KEY_ENTER]) break;
               if(key[KEY_ESC]) break;
            }

            clear_keybuf();
            set_pallete( mdlibdat[LOGO7_PAL].dat );
            MDLUnload( &model ); // free some memory

            remove( viewfile ); // delete the file
            // FIX ME!
            remove( strlwr(get_filename( paklist[ main_dlg[1].d1+1 ].filename )) );
         }

         // show texture
         if( !strcmp(tstring, "wal") )
         {
            PAKExtractFile(pakname, paklist[ main_dlg[1].d1 ]);
            set_pallete( mdlibdat[Q2_PAL].dat );
            PAKShowWAL( viewfile, screen );

            readkey();
            set_palette( mdlibdat[LOGO7_PAL].dat );
            remove( viewfile ); // delete the file
         }



      }
   }



   destroy_bitmap( dbuf );
   set_gfx_mode( GFX_TEXT, 0, 0, 0, 0 );

   unload_datafile( mdlibdat );

   remove_sound();
   remove_timer();
   remove_mouse();
   remove_keyboard();
   allegro_exit();

   printf("Visit the Clan 7 homepage at http://go.to/Clan7\n");
   printf("Send bug fix, add-ons, money, pizza or questions to l41273@alfa.ist.utl.pt\n");
   printf("\nMDLib Version %4.2f\n", LIBVERSION);

   return 0;
}


