/* read vtx files */
#include "m3d.h"

static int ReadVTX(obj *o, PACKFILE *in, float *points, int *Faces)
{
    float dum, r, g, b, u, v;
    char buf[256];
    int rr,gg,bb,i, ii, x, y, dum2;
    unsigned long col;

    i = y = x = 0;
    while (!i) {
        if (!pack_fgets(buf, 256, in)) return 0;
        if (!memcmp(buf, ".Vertex", 7)) i = 1; }

    while (pack_fgets(buf, 256, in)) {
        if (sscanf(buf, "%f %f %f %f %f %f %f %f\n",
           &points[x*5+0],&points[x*5+1],&points[x*5+2],
           &dum,&dum,&dum,&u,&v)==8) {
            points[x*5+3] = (int)((float)(1<<16) * u);
            points[x*5+4] = (int)((float)(1<<16) * v);
            ++x;
        } else break;
    }

    while (pack_fgets(buf, 256, in))
        if (!memcmp(buf, ".Index", 6)) break;
    while (pack_fgets(buf, 256, in)) {
       if (sscanf(buf, "%d %d %d %d\n",
                  &Faces[y*3+0],&Faces[y*3+1],&Faces[y*3+2],&dum2)==4) ++y;
          else break;
    }

    while (pack_fgets(buf, 256, in))
        if (!memcmp(buf, ".Brdf", 5)) break;

    while (pack_fgets(buf, 256, in))
        if (sscanf(buf, "%f %f %f\n", &r, &g, &b) == 3) break;
    rr = (int)(255.0 * r);
    gg = (int)(255.0 * g);
    bb = (int)(255.0 * b);
    col = (rr<<16)|(gg<<8)|bb;

    o->nfaces = y;
    o->nchild = 0;
    o->faces = calloc(y, sizeof(face));
    o->child = NULL;
    for (i = 0; i < y; i++) {
        o->faces[i].shadetype = POLYTYPE_FLAT;
        o->faces[i].texture = NULL;
        o->faces[i].backface = 0;
        for (ii = 0; ii < 3; ii++) {
            o->faces[i].v[ii].x = points[Faces[3*i+ii]*5+0];
            o->faces[i].v[ii].y = points[Faces[3*i+ii]*5+1];
            o->faces[i].v[ii].z = points[Faces[3*i+ii]*5+2];
            o->faces[i].v[ii].u = points[Faces[3*i+ii]*5+3];
            o->faces[i].v[ii].v = points[Faces[3*i+ii]*5+4];
            o->faces[i].v[ii].c = col;
        }
    }
    m3d_CalcNormals(o);
    m3d_FlipNormals(o);
    return 1;
}

obj *m3d_LoadVTX(char *filename)
{
    PACKFILE *in;
    obj *o;
    int y, *Faces;
    float *points;

    /* allocate ram for points */
    points = calloc(5*sizeof(float), 50000);
    Faces  = calloc(3*sizeof(int), 50000);
    in = pack_fopen(filename, "r");

    o = m3d_CreateObj(0, 1024);
    for (y = 0; y < 1024; y++)
        if (!ReadVTX(&o->child[y], in, points, Faces)) break;
    o->nchild = y;
    o->child = realloc(o->child, sizeof(obj) * y);

    free(points);
    free(Faces);
    pack_fclose(in);
    return o;
}
