/******************
* Name: TIMER.C
* Type: Linkable module (either library or object file)
* Does: Provides timer routines for the ACE package.
* Author: Peter Monks (pmonks@iname.com)
* Refer: Class TIMER in TIMER.E
*******************/

#include <stdlib.h>
#include <dos.h>
#include <conio.h>

#include "allegro.h"
#include "common.h"
#include "timer.h"


/* The array of timer counters. */
volatile int eiffel_counter[NUM_TIMERS];


/* Timer 1 handler. */
static void eiffel_timer1_proc(void)
{
    eiffel_counter[0]++;
}
static END_OF_FUNCTION(eiffel_timer1_proc);


/* Timer 2 handler. */
static void eiffel_timer2_proc(void)
{
    eiffel_counter[1]++;
}
static END_OF_FUNCTION(eiffel_timer2_proc);


/* Timer 3 handler. */
static void eiffel_timer3_proc(void)
{
    eiffel_counter[2]++;
}
static END_OF_FUNCTION(eiffel_timer3_proc);


/* The array of timer handler functions. */
static const function_pointer TimerProcs[NUM_TIMERS] =
             { &eiffel_timer1_proc,
               &eiffel_timer2_proc,
               &eiffel_timer3_proc }; 


/* Function to install a timer handler. */
inline int install_eiffel_timer(int timer, int speed)
{
    LOCK_VARIABLE(eiffel_counter[timer-1]);
    eiffel_counter[timer-1] = 0;

    if(timer == 1)
    {
        LOCK_FUNCTION(eiffel_timer1_proc);
    }
    else if (timer == 2)
    {
        LOCK_FUNCTION(eiffel_timer2_proc);
    }
    else if (timer == 3)
    {
        LOCK_FUNCTION(eiffel_timer3_proc);
    }
    
    return(install_int(TimerProcs[timer-1], speed));
}


/* Function to remove a timer handler. */
inline void remove_eiffel_timer(int timer)
{
    remove_int(TimerProcs[timer-1]);
}
