/******************
* Name: FILE.C
* Type: Linkable module (either library or object file)
* Does: Provides file tool related routines for the ACE package.
* Author: Peter Monks (pmonks@iname.com)
* Refer: Classes ACE_FILE_TOOLS in ACE_FILE_TOOLS.E,
*                FILE_ITERATOR  in FILE_ITERATOR.E
*******************/

#include <dir.h>

#include "allegro.h"
#include "common.h"
#include "file.h"


/* Wrapper for Allegro's for_each_file function. */
inline int eiffel_for_each_file(char *spec, void *object)
{
    return(for_each_file(spec, FA_ARCH | FA_RDONLY, &eiffel_for_each_file_callback, (int)object));
}


/* "Glue" callback function for Allegro's for_each_file. */
void eiffel_for_each_file_callback(char *filename, int attrib, int object)
{
    if(!eiffel_file_iterator_operation((void *)object, (void *)filename, attrib))
    {
        errno = 1;
    }
}
