indexing
    description    : "Allegro game programming library: 16.16 fixed point reference objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : fixed_ref
    date_started   : "17th December, 1996"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class FIXED_REF


inherit
    NUMERIC
    redefine
        infix "+", infix "-", infix "*", infix "/", infix "^",
        prefix "+", prefix "-", valid_divisor, one, zero
    end  -- inherit NUMERIC

    COMPARABLE
    redefine
        infix "<", compare
    end  -- inherit COMPARABLE


creation { ANY }
    make


------------------------------------------------------ Creation features
feature { ANY }

    make(value : FIXED) is
    -- Make a new fixed point reference type
    do
        item := value
    end


------------------------------------------------------ Storage features
feature { ANY }

    item : FIXED


------------------------------------------------------ Fixed features
feature { ANY }

    set_item(value: like item) is
    do
        item := value
    end


    infix "+" (other : like Current) : like Current is
    -- Add `other' to Current.
    do
        !!Result.make(item+other.item)
    end


    infix "-" (other : like Current) : like Current is
    -- Subtract `other' from Current.
    do
        !!Result.make(item-other.item)
    end


    infix "*" (other : like Current) : like Current is
    -- Multiply `other' by Current.
    do
        !!Result.make(item*other.item)
    end


    infix "/" (other : like Current) : like Current is
    -- Divide Current by `other'.
    do
        !!Result.make(item/other.item)
    end


    infix "^" (exp : INTEGER) : like Current is
    -- Raise Current to `exp'-th power.
    do
        !!Result.make(item^exp)
    end


    prefix "+" : like Current is
    do
        !!Result.make(item)
    end


    prefix "-" : like Current is
    do
        !!Result.make(-item)
    end


    infix "<" (other : like Current) : BOOLEAN is
    -- Is Current less than `other'?
    do
        Result := item < other.item
    end


    compare(other : like Current) : INTEGER is
    -- Compare Current with `other'.
    -- '<' <==> Result < 0
    -- '>' <==> Result > 0
    -- Otherwise Result = 0
    do
        Result := item.compare(other.item)
    end


    valid_divisor(other : like Current) : BOOLEAN is
    do
        Result := (other.item /= 0.0)
    end


    one : like Current is
    do
        !!Result.make(1.0)
    end


    zero : like Current is
    do
       !!Result.make(0.0)
    end


end  -- class FIXED_REF

