indexing
    description    : "Allegro con Eiffel: fixed_test program"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : fixed_test
    date_started   : "1st December, 1996"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class FIXED_TEST


creation { ANY }
    make


------------------------------------------------------ Creation features
feature { ANY }

    make is
    local
        f1 : FIXED
        f2 : FIXED
        f3 : FIXED
        i1 : INTEGER
        i2 : INTEGER
        i3 : INTEGER
        d1 : DOUBLE
        d2 : DOUBLE
        d3 : DOUBLE
        b  : BOOLEAN
    do
        io.put_string("%N%NInteger operations:")

        i1 := 1
        i2 := 2
        i3 := i1 + i2
        f1.from_integer(i1)
        f2.from_integer(i2)
        f3 := f1 + f2
        test_results("Addition", i3, f3)
--        put_infix_expression(f1, f2, f3, "+", i3)

        i1 := 1
        i2 := 3
        i3 := i1 - i2
        f1.from_integer(i1)
        f2.from_integer(i2)
        f3 := f1 - f2
        test_results("Subtraction", i3, f3)
--        put_infix_expression(f1, f2, f3, "-", i3)

        i1 := 2
        i2 := 3
        i3 := i1 * i2
        f1.from_integer(i1)
        f2.from_integer(i2)
        f3 := f1 * f2
        test_results("Multiplication", i3, f3)
--        put_infix_expression(f1, f2, f3, "*", i3)

        i1 := 6
        i2 := 3
        d1 := i1 / i2
        f1.from_integer(i1)
        f2.from_integer(i2)
        f3 := f1 / f2
        test_results("Division", d1, f3)
--        put_infix_expression(f1, f2, f3, "/", d1)

        i1 := 25
        i2 := +i1
        f1.from_integer(i1)
        f2 := +f1
        test_results("Unary plus", i2, f2)
--        put_prefix_expression(f1, f2, "+", i2)

        i1 := 3
        i2 := -i1
        f1.from_integer(i1)
        f2 := -f1
        test_results("Unary minus", i2, f2)
--        put_prefix_expression(f1, f2, "-", i2)

        i1 := 2
        i2 := 8
        i3 := i1 ^ i2
        f1.from_integer(i1)
        f2.from_integer(i2)
        f3 := f1 ^ f2.to_integer
        test_results("Power", i3, f3)
--        put_infix_expression(f1, f2, f3, "^", i3)

        i1 := -20
        i2 := i1.abs
        f1.from_integer(i1)
        f2 := f1.abs
        test_results("Absolute", i2, f2)
--        put_prefix_expression(f1, f2, "abs ", i2)

        i1 := 30
        i2 := 12
        f1.from_integer(i1)
        f2.from_integer(i2)
        b := f1 < f2
        put_boolean_expression(f1, f2, b, "<", i1<i2)

        i1 := 23
        i2 := 23
        f1.from_integer(i1)
        f2.from_integer(i2)
        b := f1 <= f2
        put_boolean_expression(f1, f2, b, "<=", i1<=i2)

        i1 := 15
        i2 := 15
        f1.from_integer(i1)
        f2.from_integer(i2)
        b := f1 > f2
        put_boolean_expression(f1, f2, b, ">", i1>i2)

        i1 := 101
        i2 := 12
        f1.from_integer(i1)
        f2.from_integer(i2)
        b := f1 >= f2
        put_boolean_expression(f1, f2, b, ">=", i1>=i2)

        i1 := 24
        i2 := 22
        f1.from_integer(i1)
        f2.from_integer(i2)
        i3 := f1.compare(f2)
        put_integer_expression(f1, f2, i3, ".compare ", i1.compare(i2))

        i1 := 0
        i2 := 0
        f1.from_integer(i1)
        f2.from_integer(i2)      -- Not actually used in this test
        b := f1.valid_divisor(f1)
        put_boolean_expression(f1, f2, b, ".valid_divisor ", i1.valid_divisor(i1))

        i1 := 10
        i2 := i1.one
        f1.from_integer(i1)
        f2 := f1.one
        test_results("one", i2, f2)
--        put_prefix_expression(f1, f2, "one.", i2)

        i1 := 13
        i2 := i1.zero
        f1.from_integer(i1)
        f2 := f1.zero
        test_results("zero", i2, f2)
--        put_prefix_expression(f1, f2, "zero.", i2)

        i1 := 49
        d1 := i1.sqrt
        f1.from_integer(i1)
        f2 := f1.sqrt
        test_results("sqrt", d1, f2)
--        put_prefix_expression(f1, f2, "sqrt.", d1)


        io.put_string("%N%NDecimal operations:")

        d1 := 1.1
        d2 := 2.2
        d3 := d1 + d2
        f1.from_double(d1)
        f2.from_double(d2)
        f3 := f1 + f2
        test_results("Addition", d3, f3)
--        put_infix_expression(f1, f2, f3, "+", d3)

        d1 := 3.4
        d2 := 1.2
        d3 := d1 - d2
        f1.from_double(d1)
        f2.from_double(d2)
        f3 := f1 - f2
        test_results("Subtraction", d3, f3)
--        put_infix_expression(f1, f2, f3, "-", d3)

        d1 := 2.1
        d2 := 2.4
        d3 := d1 * d2
        f1.from_double(d1)
        f2.from_double(d2)
        f3 := f1 * f2
        test_results("Multiplication", d3, f3)
--        put_infix_expression(f1, f2, f3, "*", d3)

        d1 := 6.6
        d2 := 3.1
        d3 := d1 / d2
        f1.from_double(6.6)
        f2.from_double(3.1)
        f3 := f1 / f2
        test_results("Division", d3, f3)
--        put_infix_expression(f1, f2, f3, "/", d3)

        d1 := 25.4
        d2 := +d1
        f1.from_double(d1)
        f2 := +f1
        test_results("Unary plus", d2, f2)
--        put_prefix_expression(f1, f2, "+", d2)

        d1 := 3.75
        d2 := -d1
        f1.from_double(d1)
        f2 := -f1
        test_results("Unary minus", d2, f2)
--        put_prefix_expression(f1, f2, "-", d2)

        d1 := 2.8
        i1 := 8
        d2 := d1 ^ i1
        f1.from_double(d1)
        f2.from_integer(i1)
        f3 := f1 ^ f2.to_integer
        test_results("Power", d2, f3)
--        put_infix_expression(f1, f2, f3, "^", d2)

        d1 := -20.24
        d2 := d1.abs
        f1.from_double(d1)
        f2 := f1.abs
        test_results("Absolute", d2, f2)
--        put_prefix_expression(f1, f2, "abs ", d2)

        d1 := 30.10
        d2 := 11.97
        f1.from_double(d1)
        f2.from_double(d2)
        b := f1 < f2
        put_boolean_expression(f1, f2, b, "<", d1<d2)

        d1 := 23.1
        d2 := 23.1
        f1.from_double(d1)
        f2.from_double(d2)
        b := f1 <= f2
        put_boolean_expression(f1, f2, b, "<=", d1<=d2)

        d1 := 15.4
        d2 := 15.4
        f1.from_double(d1)
        f2.from_double(d2)
        b := f1 > f2
        put_boolean_expression(f1, f2, b, ">", d1>d2)

        d1 := 101.01
        d2 := 12.12
        f1.from_double(d1)
        f2.from_double(d2)
        b := f1 >= f2
        put_boolean_expression(f1, f2, b, ">=", d1>=d2)

        d1 := 24.54
        d2 := 22.025
        f1.from_double(d1)
        f2.from_double(d2)
        i3 := f1.compare(f2)
        put_integer_expression(f1, f2, i3, ".compare ", d1.compare(d2))

        d1 := 0.0
        d2 := 0.0
        f1.from_double(d1)
        f2.from_double(d2)      -- Not actually used in this test
        b := f1.valid_divisor(f1)
        put_boolean_expression(f1, f2, b, ".valid_divisor ", d1.valid_divisor(d1))

        d1 := 10.575
        d2 := d1.one
        f1.from_double(d1)
        f2 := f1.one
        test_results("one", d2, f2)
--        put_prefix_expression(f1, f2, "one.", d2)

        d1 := 13.975
        d2 := d1.zero
        f1.from_double(d1)
        f2 := f1.zero
        test_results("zero", d2, f2)
--        put_prefix_expression(f1, f2, "zero.", d2)

        d1 := 49.50
        d2 := d1.sqrt
        f1.from_double(d1)
        f2 := f1.sqrt
        test_results("sqrt", d2, f2)
--        put_prefix_expression(f1, f2, "sqrt.", d2)

        io.put_string("%N%NThe End!")
    end  -- feature make


    test_results(test : STRING; expected_result : DOUBLE; actual_result : FIXED) is
    require
        test_is_valid : test /= Void
    do
        io.put_string("%N")
        io.put_string(test)
        io.put_string(": ")

        if actual_result.to_double = expected_result then
            io.put_string("passed.")
        else
            io.put_string("FAILED!  Expected: ")
            io.put_string(expected_result.to_string_format(6))
            io.put_string("  Actual: ")
            io.put_string(actual_result.to_string_format(6))
        end  -- if
    end  -- feature test_results


    put_infix_expression(f1, f2, f3 : FIXED; op : STRING; expected_result : DOUBLE) is
    require
        op_is_valid : op /= Void
    do
        io.put_string("%N")
        io.put_string(f1.to_string_format(6))
        io.put_string(op)
        io.put_string(f2.to_string_format(6))
        io.put_string("=")
        io.put_string(f3.to_string_format(6))
        io.put_string(" (expected: ")
        io.put_string(expected_result.to_string_format(6))
        io.put_string(")")
    end  -- feature put_infix_expression


    put_prefix_expression(f1, f2 : FIXED; op : STRING; expected_result : DOUBLE) is
    require
        op_is_valid : op /= Void
    do
        io.put_string("%N")
        io.put_string(op)
        io.put_string(f1.to_string_format(6))
        io.put_string("=")
        io.put_string(f2.to_string_format(6))
        io.put_string(" (expected: ")
        io.put_string(expected_result.to_string_format(6))
        io.put_string(")")
    end  -- feature put_prefix_expression


    put_boolean_expression(f1, f2 : FIXED; actual_result : BOOLEAN; op : STRING; expected_result : BOOLEAN) is
    require
        op_is_valid : op /= Void
    do
        io.put_string("%N")
        io.put_string(f1.to_string_format(6))
        io.put_string(op)
        io.put_string(f2.to_string_format(6))
        io.put_string("=")
        io.put_boolean(actual_result)
        io.put_string(" (expected: ")
        io.put_boolean(expected_result)
        io.put_string(")")
    end  -- feature put_boolean_expression


    put_integer_expression(f1, f2 : FIXED; actual_result : INTEGER; op : STRING; expected_result : INTEGER) is
    require
        op_is_valid : op /= Void
    do
        io.put_string("%N")
        io.put_string(f1.to_string_format(6))
        io.put_string(op)
        io.put_string(f2.to_string_format(6))
        io.put_string("=")
        io.put_integer(actual_result)
        io.put_string(" (expected: ")
        io.put_integer(expected_result)
        io.put_string(")")
    end  -- feature put_boolean_expression

end  -- class FIXED_TEST
