/*
 * SYSINFO.CPP - The main file.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

// ID for this file.
#define _SYSINFO_CC_

#include "sysinfo.h"
#include "commdlg.h"

int stopflag = 0;
extern unsigned short video_base;
char stopstr[] = "SYSINFO will halt shortly. Please wait ...";

char *iniline[] =
{
	"CPU=",
	"BIOS=",
	"APM=",
	"VIDEO=",
	"BUSES=",
	"PCIAGP=",
	"KEYBD=",
	"RTC=",
	"CMOS=",
	"FDD=",
	"HDD=",
	"SERIAL=",
	"PARALLEL=",
	"MSCDEX=",
	"IDEHDD=",
	"ATAPICD=",
	"PNP=",
	"DMI=",
	"MEMORY=",
	"DOS=",
	"INTERRUPTS=",
	"SYSFILES=",
};

void open_stderr()
{
	fclose(stdout);
	fclose(&_streams[2]);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if ((stderr = fopen("errors.$$$", "ab")) == NULL) exit(0x7f);
}

void set_exception_handlers();
void reset_exception_handlers();

void interrupt (*oldint9)(...);

void interrupt int9(...)
{
	int f = 1156, g = 0;
	if (inportb(0x60) == 1) {
		while (stopstr[g])
		{
			*(char *)MK_FP(video_base, f++) = stopstr[g++];
			*(char *)MK_FP(video_base, f++) = 0x1e;
		}
		stopflag = 1;
	}
	outportb(0x20, 0x20);
}

int main()
{
 set_exception_handlers();
 atexit(stop_indicator);

 open_stderr();

 SysInfo().run();
 cprintf("Error: Could not spawn the text reader.\n\r"
	 "       Please type READER sysinfo.txt at the DOS prompt.\n\r");
 return 0;
}

// Class Member functions.
void SysInfo :: progbar(int x, int y)
{
	int f;
	textcolor(WHITE); textbackground(RED);
	if (!x) return;
	gotoxy(10, 23);
	for(f = 0; f <= 60 * x / y + 1; f++)
	cprintf(" ");
	textcolor(WHITE); textbackground(BLUE);
	gotoxy(4, 23); cprintf("%d %%", 100 * x / y);
	textcolor(WHITE); textbackground(RED);
}

void SysInfo :: markentry(int x, int y, char c)
{
	textcolor(WHITE); textbackground(BLUE);
	gotoxy(x, y); cprintf("%c", c);
	textcolor(WHITE); textbackground(BLACK);
}

void SysInfo :: runreader()
{
 stop_indicator();
 setvect(0x09, oldint9);
 reset_exception_handlers();
 fclose(fp);
 spawnl(P_OVERLAY, "reader.exe", "reader.exe", "sysinfo.txt", NULL);
}

void SysInfo :: run()
{
 struct date dt;
 struct time tm;
 char output[256];

 oldint9 = getvect(0x09);
 setvect(0x09, int9);

 sngbox(20, 10, 60, 14, WHITE, BLACK);
 textcolor(WHITE); textbackground(RED);
 gotoxy(21, 12); cprintf("                                       ");

 start_indicator();

 unlink("errors.$$$");
 unlink("pin.$$$");
 unlink("temp.$$$");

 // Store into a file.
 if ((fp = fopen("sysinfo.txt", "wb")) == NULL) {
    errflag = 1;
    checkerrors();
    exit(0x7f);
 }

 // Get date and time first.
 getdate(&dt);
 gettime(&tm);

 // Write header.
 progbar(0, 22);
 writestring("------------------------------------------------------------------------------\n");
 writestring("*** SysInfo for PDiag, Copyright (C) 1999 Prashant TR\n");
 writestring("    This program is redistributable under the GNU GPL.\n");
 writestring("    See the files COPYING.TR and COPYING.\n");
 writestring("------------------------------------------------------------------------------\n");
 writestring("; Report file created by SYSINFO.EXE\n");
 writestring("; SYSINFO.EXE is a part of PDIAG, a diagnostic utility.\n");
 sprintf(output, "; Report created on %02d/%02d/%04d (dd/mm/yyyy)\n",
		 dt.da_day,
		 dt.da_mon,
		 dt.da_year);
 writestring(output);
 sprintf(output, "; Created at %02d:%02d:%02d (hh:mm:ss)\n",
		 tm.ti_hour,
		 tm.ti_min,
		 tm.ti_sec);
 writestring(output);
 writestring("------------------------------------------------------------------------------\n");
 writestring("------------------------------------------------------------------------------\n");
 writestring("; You can get SysInfo from\n;\n");
 writestring(";               http://www.members.tripod.com/prashant_tr\n;\n");
 writestring("; Please check website validity. I'll make changes in the documentations\n");
 writestring("; if I change the website so that everyone knows about it.\n");
 writestring("------------------------------------------------------------------------------\n");
 writestring("------------------------------------------------------------------------------\n");
 writestring("; If you make significant changes, send E-Mail to midpec@yahoo.com or\n");
 writestring("; prashant_tr@yahoo.com so that we can have the latest version of this.\n;\n");
 writestring("------------------------------------------------------------------------------\n");
 writestring("------------------------------------------------------------------------------\n");
 writestring("; This Software was written by :\n;\n");
 writestring(";    Prashant TR  - (prashant_tr@yahoo.com)\n;\n");
 writestring(";    Thanks to Suresh PK  - (pk_suresh@yahoo.com)\n");
 writestring(";    and ShubhaPrada HT (for providing net access)\n");
 writestring("------------------------------------------------------------------------------\n;\n");
 writestring("------------------------------------------------------------------------------\n");
 writestring(";                        PDIAG SYSTEM INFORMATION\n");
 writestring("------------------------------------------------------------------------------\n");

 // Get CPU information.
 if (runyn[0]) {
 gotoxy(23, 12); cprintf("     Identifying CPU type ...     ");
 writestring("*** CPU INFORMATION ***\n");
 writestring("------------------------------------------------------------------------------\n");
 runmod("sysinfo.pin", "cpu.exe", "cpu.txt");
 writestring("\n------------------------------------------------------------------------------\n");
 markentry(6, 3, 'X');
 progbar(1, 22);
 if (stopflag) {
	runreader();
	return;
 }
 }

 // BIOS Information.
 if (runyn[1]) {
 gotoxy(23, 12); cprintf("   Getting BIOS Information ...   ");
 writestring("*** BIOS INFORMATION ***\n");
 writestring("------------------------------------------------------------------------------\n");
 runmod("sysinfo.pin", "bios.exe", "bios.txt");
 writestring("\n------------------------------------------------------------------------------\n");
 markentry(36, 3, 'X');
 progbar(2, 22);
 if (stopflag) {
	runreader();
	return;
 }
 }

 // APM information.
 if (runyn[2]) {
 gotoxy(23, 12); cprintf("    Getting APM Information ...   ");
 writestring("*** POWER MANAGEMENT INFORMATION ***\n");
 writestring("------------------------------------------------------------------------------\n");
 runmod("sysinfo.pin", "apm.exe", "apm.txt");
 writestring("\n------------------------------------------------------------------------------\n");
 markentry(61, 3, 'X');
 progbar(3, 22);
 if (stopflag) {
	runreader();
	return;
 }
 }

 // Video information.
 if (runyn[3]) {
 gotoxy(23, 12); cprintf("   Checking Video subsystem ...   ");
 writestring("*** VIDEO SYSTEM INFORMATION ***\n");
 writestring("------------------------------------------------------------------------------\n");
 runmod("sysinfo.pin", "video.exe", "video.txt");
 writestring("\n------------------------------------------------------------------------------\n");
 markentry(6, 4, 'X');
 progbar(4, 22);
 if (stopflag) {
	runreader();
	return;
 }
 }

 // Buses information.
 if (runyn[4]) {
 gotoxy(23, 12); cprintf("   Detecting Buses Installed ...  ");
 writestring("*** BUSES INFORMATION ***\n");
 writestring("------------------------------------------------------------------------------\n");
 runmod("sysinfo.pin", "buses.exe", "buses.txt");
 writestring("\n------------------------------------------------------------------------------\n");
 markentry(36, 4, 'X');
 progbar(5, 22);
 if (stopflag) {
	runreader();
	return;
 }
 }

 // PCI/AGP device(s) information.
 if (runyn[5]) {
 gotoxy(23, 12); cprintf("      Scanning PCI/AGP Bus ...    ");
 writestring("*** PCI/AGP INFORMATION ***\n");
 writestring("------------------------------------------------------------------------------\n");
 runmod("sysinfo.pin", "pciagp.exe", "pciagp.txt");
 writestring("\n------------------------------------------------------------------------------\n");
 markentry(61, 4, 'X');
 progbar(6, 22);
 if (stopflag) {
	runreader();
	return;
 }
 }

 // Keyboard information.
 if (runyn[6]) {
 gotoxy(23, 12); cprintf(" Getting Keyboard Information ... ");
 writestring("*** KEYBOARD INFORMATION ***\n");
 writestring("------------------------------------------------------------------------------\n");
 runmod("sysinfo.pin", "kbd.exe", "kbd.txt");
 writestring("\n------------------------------------------------------------------------------\n");
 markentry(6, 5, 'X');
 progbar(7, 22);
 if (stopflag) {
	runreader();
	return;
 }
 }

 // RTC information.
 if (runyn[7]) {
 gotoxy(23, 12); cprintf("   Checking Real Time Clock ...   ");
 writestring("*** REAL TIME CLOCK INFORMATION ***\n");
 writestring("------------------------------------------------------------------------------\n");
 runmod("sysinfo.pin", "rtc.exe", "rtc.txt");
 writestring("\n------------------------------------------------------------------------------\n");
 markentry(36, 5, 'X');
 progbar(8, 22);
 if (stopflag) {
	runreader();
	return;
 }
 }

 // CMOS information.
 if (runyn[8]) {
 gotoxy(23, 12); cprintf("     Reading CMOS RAM Block ...   ");
 writestring("*** CMOS INFORMATION ***\n");
 writestring("------------------------------------------------------------------------------\n");
 runmod("sysinfo.pin", "cmos.exe", "cmos.txt");
 writestring("\n------------------------------------------------------------------------------\n");
 markentry(61, 5, 'X');
 progbar(9, 22);
 if (stopflag) {
	runreader();
	return;
 }
 }

 // FDD information.
 if (runyn[9]) {
 gotoxy(23, 12); cprintf("   Identifying Floppy Drives ...  ");
 writestring("*** FLOPPY DRIVE(S) INFORMATION ***\n");
 writestring("------------------------------------------------------------------------------\n");
 runmod("sysinfo.pin", "fdd.exe", "fdd.txt");
 writestring("\n------------------------------------------------------------------------------\n");
 markentry(6, 17, 'X');
 progbar(10, 22);
 if (stopflag) {
	runreader();
	return;
 }
 }

 // HDD information.
 if (runyn[10]) {
 gotoxy(23, 12); cprintf("    Identifying Hard Drives ...   ");
 writestring("*** HARD DISK(S) INFORMATION ***\n");
 writestring("------------------------------------------------------------------------------\n");
 runmod("sysinfo.pin", "hdd.exe", "hdd.txt");
 writestring("\n------------------------------------------------------------------------------\n");
 markentry(36, 17, 'X');
 progbar(11, 22);
 if (stopflag) {
	runreader();
	return;
 }
 }

 // Serial ports information.
 if (runyn[11]) {
 gotoxy(22, 12); cprintf("Getting Serial Ports Information ... ");
 writestring("*** SERIAL PORT(S) INFORMATION ***\n");
 writestring("------------------------------------------------------------------------------\n");
 runmod("sysinfo.pin", "serial.exe", "serial.txt");
 writestring("\n------------------------------------------------------------------------------\n");
 markentry(61, 17, 'X');
 progbar(12, 22);

 if (stopflag) {
	runreader();
	return;
 }
 }

 // Parallel ports information.
 if (runyn[12]) {
 gotoxy(21, 12); cprintf("Getting Parallel Ports Information ...");
 writestring("*** PARALLEL PORT(S) INFORMATION ***\n");
 writestring("------------------------------------------------------------------------------\n");
 runmod("sysinfo.pin", "parallel.exe", "parallel.txt");
 writestring("\n------------------------------------------------------------------------------\n");
 markentry(6, 18, 'X');
 progbar(13, 22);
 if (stopflag) {
	runreader();
	return;
 }
 }

 // MSCDEX CDROM(s) information.
 if (runyn[13]) {
 gotoxy(21, 12); cprintf("      Checking CDROM Extensions ...   ");
 writestring("*** MSCDEX CDROM(S) INFORMATION ***\n");
 writestring("------------------------------------------------------------------------------\n");
 runmod("sysinfo.pin", "mscd.exe", "mscd.txt");
 writestring("\n------------------------------------------------------------------------------\n");
 markentry(36, 18, 'X');
 progbar(14, 22);
 if (stopflag) {
	runreader();
	return;
 }
 }

 // IDE HDD(s) information.
 if (runyn[14]) {
 gotoxy(23, 12); cprintf("    Autodetecting IDE HDD(s) ...    ");
 writestring("*** IDE HDD(S) INFORMATION ***\n");
 writestring("------------------------------------------------------------------------------\n");
 runmod("sysinfo.pin", "idehdd.exe", "idehdd.txt");
 writestring("\n------------------------------------------------------------------------------\n");
 markentry(61, 18, 'X');
 progbar(15, 22);
 if (stopflag) {
	runreader();
	return;
 }
 }

 // IDE CDROM(s) information.
 if (runyn[15]) {
 gotoxy(23, 12); cprintf("    Checking ATAPI CDROM(s) ...   ");
 writestring("*** IDE CDROM(S) INFORMATION ***\n");
 writestring("------------------------------------------------------------------------------\n");
 runmod("sysinfo.pin", "idecd.exe", "idecd.txt");
 writestring("\n------------------------------------------------------------------------------\n");
 markentry(6, 19, 'X');
 progbar(16, 22);
 if (stopflag) {
	runreader();
	return;
 }
 }

 // Plug and Play information.
 if (runyn[16]) {
 gotoxy(22, 12); cprintf(" Scanning Plug and Play Devices ... ");
 writestring("*** PLUG AND PLAY INFORMATION ***\n");
 writestring("------------------------------------------------------------------------------\n");
 runmod("sysinfo.pin", "pnp.exe", "pnp.txt");
 writestring("\n------------------------------------------------------------------------------\n");
 markentry(36, 19, 'X');
 progbar(17, 22);
 if (stopflag) {
	runreader();
	return;
 }
 }

 // DMI information.
 if (runyn[17]) {
 gotoxy(23, 12); cprintf("    Getting DMI Information ...   ");
 writestring("*** DMI INFORMATION ***\n");
 writestring("------------------------------------------------------------------------------\n");
 runmod("sysinfo.pin", "dmi.exe", "dmi.txt");
 writestring("\n------------------------------------------------------------------------------\n");
 markentry(61, 19, 'X');
 progbar(18, 22);
 if (stopflag) {
	runreader();
	return;
 }
 }

 // Memory information.
 if (runyn[18]) {
 gotoxy(23, 12); cprintf("   Getting DRAM Information ...   ");
 writestring("*** MEMORY INFORMATION ***\n");
 writestring("------------------------------------------------------------------------------\n");
 runmod("sysinfo.pin", "memory.exe", "memory.txt");
 writestring("\n------------------------------------------------------------------------------\n");
 markentry(6, 20, 'X');
 progbar(19, 22);
 if (stopflag) {
	runreader();
	return;
 }
 }

 // DOS information.
 if (runyn[19]) {
 gotoxy(23, 12); cprintf("   Getting DOS Information ...   ");
 writestring("*** DOS INFORMATION ***\n");
 writestring("------------------------------------------------------------------------------\n");
 runmod("sysinfo.pin", "dosinfo.exe", "dosinfo.txt");
 writestring("\n------------------------------------------------------------------------------\n");
 markentry(36, 20, 'X');
 progbar(20, 22);
 if (stopflag) {
	runreader();
	return;
 }
 }

 // Interrupts information.
 if (runyn[20]) {
 gotoxy(23, 12); cprintf("Getting Interrupts Information ...");
 writestring("*** INTERRUPTS INFORMATION ***\n");
 writestring("------------------------------------------------------------------------------\n");
 runmod("sysinfo.pin", "intrinfo.exe", "intrinfo.txt");
 writestring("\n------------------------------------------------------------------------------\n");
 markentry(61, 20, 'X');
 progbar(21, 22);
 if (stopflag) {
	runreader();
	return;
 }
 }

 // System files.
 if (runyn[21]) {
 gotoxy(23, 12); cprintf("      Adding System files ...     ");
 writestring("*** OPERATION SYSTEM  CONFIGURATIONS ***\n");
 writestring("------------------------------------------------------------------------------\n");
 runmod("sysinfo.pin", "sysfiles.exe", "sysfiles.txt");
 writestring("\n------------------------------------------------------------------------------\n");
 progbar(22, 22);
 if (stopflag) {
	runreader();
	return;
 }
 }

 // End of report.
 writestring("*** END OF REPORT ***\n");
 writestring("------------------------------------------------------------------------------\n");
 fclose(fp);

 stop_indicator();

 delay(1000);
 gotoxy(23, 12); cprintf("      Running Text Reader ...     ");

 runreader();
}

// Write any string to the file and check for successfulness.
void SysInfo :: writestring(const char *string)
{
 if (fprintf(fp, "%s", string) == EOF) {
    errflag = 2;
    checkerrors();
    fclose(fp);
    exit(0x7f);
 }
}

// Set configuration.
void SysInfo :: setconfig()
{
	int f = 0;
	FILE *fp;
	if ((fp = fopen("sysinfo.ini", "rb")) == NULL) {
		fprintf(stderr, "\nError: Could not open SYSINFO.INI.\n");
		exit(0x7f);
	}
	while (fgets(output, 255, fp) != NULL)
	{
		for(f = 0; f < MAXMODULES; f++)
		if (!strncmp(output, iniline[f], strlen(iniline[f]))) {
			if (!strncmp(&output[strlen(iniline[f])], "YES", 3))
				runyn[f] = 1;

			else if (!strncmp(&output[strlen(iniline[f])],
								"NO", 2))
				runyn[f] = 0;

			else {
				fprintf(stderr,
					"\nError: Invalid entry in "
						"SYSINFO.INI\n");
				fclose(fp);
				exit(0x7f);
			}
		}
/*		if (f == MAXMODULES) {
			fprintf(stderr, "\nError: Invalid entry in "
						"SYSINFO.INI\n");
			fclose(fp);
			exit(0x7f);
		}*/
	}
	fclose(fp);
}

// Constructor.
SysInfo :: SysInfo()
{
 int f;

 // Setup "out of memory" handler.
 set_new_handler(newhandler);

 // Initialize class members.
 errflag = 0;

 // Reset all configurations.
 for(f = 0; f < MAXMODULES; f++)
 runyn[f] = 0;

 // Initialize and read the INI file.
 setconfig();

 _setcursortype(_NOCURSOR);
 sngbox(1,1, 80, 24, WHITE, BLUE);
 gotoxy(17, 1); cprintf(" * * * PDIAG SYSTEM INFORMATION (SYSINFO) * * * ");
 gotoxy(17, 2); cprintf("         Copyright (C) 1999 Prashant TR  ");
 gotoxy(5, 3);  cprintf("[ ]  1. CPU  ");
 gotoxy(35, 3); cprintf("[ ]  2. BIOS ");
 gotoxy(60, 3); cprintf("[ ]  3. APM  ");

 gotoxy(5, 4);  cprintf("[ ]  5. VIDEO   ");
 gotoxy(35, 4); cprintf("[ ]  6. BUSES   ");
 gotoxy(60, 4); cprintf("[ ]  7. PCI/AGP ");

 gotoxy(5, 5);  cprintf("[ ]  8. KEYBOARD ");
 gotoxy(35, 5); cprintf("[ ]  9. RTC      ");
 gotoxy(60, 5); cprintf("[ ] 10. CMOS     ");

 gotoxy(5, 17);  cprintf("[ ] 11. FDD      ");
 gotoxy(35, 17); cprintf("[ ] 12. HDD      ");
 gotoxy(60, 17); cprintf("[ ] 13. SERIAL   ");

 gotoxy(5, 18);  cprintf("[ ] 14. PARALLEL ");
 gotoxy(35, 18); cprintf("[ ] 15. MSCDEX   ");
 gotoxy(60, 18); cprintf("[ ] 16. IDE      ");

 gotoxy(5, 19);  cprintf("[ ] 17. ATAPI    ");
 gotoxy(35, 19); cprintf("[ ] 18. PnP      ");
 gotoxy(60, 19); cprintf("[ ] 19. DMI      ");

 gotoxy(5, 20);  cprintf("[ ] 20. DRAM       ");
 gotoxy(35, 20); cprintf("[ ] 21. DOS        ");
 gotoxy(60, 20); cprintf("[ ] 22. INTERRUPTS ");

 textcolor(YELLOW + BLINK);
 gotoxy(31, 8); cprintf(" Press ESC to Stop ");
 textcolor(YELLOW);
 gotoxy(17, 1); cprintf(" * * * PDIAG SYSTEM INFORMATION (SYSINFO) * * * ");

 textcolor(WHITE); textbackground(LIGHTGRAY);
 gotoxy(10, 23);
 for(f = 10; f <= 71; f++)
 cprintf(" ");
}

// Destructor.
SysInfo :: ~SysInfo()
{
	textcolor(LIGHTGRAY); textbackground(BLACK);
	clrscr();
	_setcursortype(_NORMALCURSOR);
}
