/*
 * PCIAGP.H - Contains PCI/AGP bus function headers.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

// ID for this file.
#define _PCIAGP_H_

// Number of PINFILES.
#define PINFILES 15

// Include all headers.
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>
#include <conio.h>
#include <alloc.h>
#include <dos.h>
#include <bios.h>
#include <dpmi.h>
#include <go32.h>
#include <new.h>
#include <process.h>
#include <dir.h>
#include <errno.h>
#include <string.h>
#include <io.h>
#include <allegro.h>
#include <sys/nearptr.h>
#include <sys/farptr.h>

typedef unsigned short WORD;
typedef unsigned long DWORD;
typedef unsigned char BYTE;

// Include our headers.
#include "external.h"

// Define the structures & unions.

typedef struct PCIcfg {
   WORD	 vendorID ;
   WORD	 deviceID ;
   WORD	 command_reg ;
   WORD	 status_reg ;
   BYTE	 revisionID ;
   BYTE	 progIF ;
   BYTE	 subclass ;
   BYTE	 classcode ;
   BYTE	 cacheline_size ;
   BYTE	 latency ;
   BYTE	 header_type ;
   BYTE	 BIST ;
   union {
      struct {
	 DWORD base_address0 ;
	 DWORD base_address1 ;
	 DWORD base_address2 ;
	 DWORD base_address3 ;
	 DWORD base_address4 ;
	 DWORD base_address5 ;
	 DWORD CardBus_CIS ;
	 WORD  subsystem_vendorID ;
	 WORD  subsystem_deviceID ;
	 DWORD expansion_ROM ;
	 BYTE  cap_ptr ;
	 BYTE  reserved1[3] ;
	 DWORD reserved2[1] ;
	 BYTE  interrupt_line ;
	 BYTE  interrupt_pin ;
	 BYTE  min_grant ;
	 BYTE  max_latency ;
	 DWORD device_specific[48] ;
	 } nonbridge ;
      struct {
	 DWORD base_address0 ;
	 DWORD base_address1 ;
	 BYTE  primary_bus ;
	 BYTE  secondary_bus ;
	 BYTE  subordinate_bus ;
	 BYTE  secondary_latency ;
	 BYTE  IO_base_low ;
	 BYTE  IO_limit_low ;
	 WORD  secondary_status ;
	 WORD  memory_base_low ;
	 WORD  memory_limit_low ;
	 WORD  prefetch_base_low ;
	 WORD  prefetch_limit_low ;
	 DWORD prefetch_base_high ;
	 DWORD prefetch_limit_high ;
	 WORD  IO_base_high ;
	 WORD  IO_limit_high ;
	 DWORD reserved2[1] ;
	 DWORD expansion_ROM ;
	 BYTE  interrupt_line ;
	 BYTE  interrupt_pin ;
	 WORD  bridge_control ;
	 DWORD device_specific[48] ;
	 } bridge ;
      struct {
	 DWORD ExCa_base ;
	 BYTE  cap_ptr ;
	 BYTE  reserved05 ;
	 WORD  secondary_status ;
	 BYTE  PCI_bus ;
	 BYTE  CardBus_bus ;
	 BYTE  subordinate_bus ;
	 BYTE  latency_timer ;
	 DWORD memory_base0 ;
	 DWORD memory_limit0 ;
	 DWORD memory_base1 ;
	 DWORD memory_limit1 ;
	 WORD  IObase_0low ;
	 WORD  IObase_0high ;
	 WORD  IOlimit_0low ;
	 WORD  IOlimit_0high ;
	 WORD  IObase_1low ;
	 WORD  IObase_1high ;
	 WORD  IOlimit_1low ;
	 WORD  IOlimit_1high ;
	 BYTE  interrupt_line ;
	 BYTE  interrupt_pin ;
	 WORD  bridge_control ;
	 WORD  subsystem_vendorID ;
	 WORD  subsystem_deviceID ;
	 DWORD legacy_baseaddr ;
	 DWORD cardbus_reserved[14] ;
	 DWORD vendor_specific[32] ;
	 } cardbus ;
      } ;
   } PCICFG;
