; * ICDCDA.ASM - Contains low-level CDROM functions.
; * Copyright (C) 1998, 1999 Prashant TR
; *
; * This program is free software; you can redistribute it and/or modify
; * it under the terms of the GNU General Public License as published by
; * the Free Software Foundation; either version 2 of the License, or
; * (at your option) any later version.
; *
; * See the file COPYING.TR for more details.

; Assembly functions to get IDE HDD information.

; Define global variables.
PUBLIC _idecd_info_block
PUBLIC _ata_info

; Define global function(s).
PUBLIC _get_ide_cd_info
PUBLIC _get_ide_cd_ata_info


_TEXT	SEGMENT BYTE PUBLIC 'CODE'
ASSUME CS:_TEXT, DS:_DATA
.386P

delay	PROC	NEAR
	PUSH	CX
	PUSH	DX
	MOV	DX, AX
	SHR	EAX, 16
	MOV	CX, AX
	MOV	AH, 86H
	INT	15H
	POP	DX
	POP	CX
	RET
delay	ENDP

; To get IDE CD info.
_get_ide_cd_info	PROC	FAR
	PUSH	BP
	MOV	BP, SP
	PUSH	CX
	PUSH	DX
	PUSH	DI

	; Write to HDD control register.
	MOV	DX, [BP + 6]
	MOV	AL, [BP + 8]
	ADD	DX, 6
	OUT	DX, AL

	; Identify drive.
	MOV	AL, 0A1H
	INC	DX
	OUT	DX, AL

	MOV	EAX, 49E30H
	CALL	delay

	; Check if command ended in error.
	IN	AL, DX
	TEST	AL, 1
	JZ      _ide_cd_info_cmd_passed

	JMP     _ide_cd_info_not_found

_ide_cd_info_cmd_passed:

	MOV	EAX, 49E30H
	CALL	delay

	; See if sector buffer is ready.
	IN	AL, DX
	TEST	AL, 8
	JNZ     _ide_cd_info_getinfo

	JMP     _ide_cd_info_not_found

_ide_cd_info_getinfo:
	MOV	CX, 100H
	MOV	DI, OFFSET _idecd_info_block
	MOV	AX, DS
	MOV	ES, AX
	SUB	DX, 7
	CLD
_ide_cd_info_getstring:
	REP	INSW
	POP	DI
	POP	DX
	POP	CX
	POP	BP
	XOR	AX, AX
	INC	AX
	MOV	DX, AX
	RET
_ide_cd_info_not_found:
	POP	DI
	POP	BX
	POP	CX
	POP	BP
	XOR	AX, AX
	MOV	DX, AX
	RET

_get_ide_cd_info	ENDP


; To get IDE CD ATAPI info.
_get_ide_cd_ata_info	PROC	FAR
	PUSH	BP
	MOV	BP, SP
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI

	; Write to HDD control register.
	MOV	DX, [BP + 6]
	MOV	AL, [BP + 8]
	ADD	DX, 6
	OUT	DX, AL

	; Check if sector buffer is ready and if any command is pending.
	MOV	EAX, 49E30H
	CALL	delay

	IN	AL, DX
	INC	DX
	TEST	AL, 1
	JZ	_ide_cd_ata_info_cmd_passed

	IN	AL, DX
	TEST	AL, 80H

	JZ	_ide_cd_ata_info_cmd_passed
	JMP     _ide_cd_ata_info_not_found
_ide_cd_ata_info_cmd_passed:

	MOV	EAX, 49E30H
	CALL	delay

	; See if sector buffer is ready.
	IN	AL, DX
	TEST	AL, 8
	JZ      _ide_cd_ata_info_getinfo

	JMP     _ide_cd_ata_info_not_found

_ide_cd_ata_info_getinfo:
	MOV	SI, OFFSET _ata_info
	CLD
	MOV	DX, [BP + 6]
	INC	DX
	LODSB
	OUT	DX, AL
	LODSB
	ADD	DX, 3
	OUT	DX, AL
	INC	DX
	LODSB
	OUT	DX, AL
	ADD	DX, 2
	MOV	AL, 0A0H
	OUT	DX, AL

	MOV	EAX, 49E30H
	CALL	delay

	IN	AL, DX
	TEST	AL, 80H
	JNZ	_ide_cd_ata_info_not_found3
	TEST	AL, 1
	JNZ	_ide_cd_ata_info_not_found3
	TEST	AL, 8
	JNZ	_ide_cd_ata_info_found
_ide_cd_ata_info_not_found3:
	JMP	_ide_cd_ata_info_not_found

_ide_cd_ata_info_found:
	MOV	DX, [BP + 6]
	LODSW
	OUT	DX, AX
	LODSW
	OUT	DX, AX
	LODSW
	OUT	DX, AX
	LODSW
	OUT	DX, AX
	LODSW
	OUT	DX, AX
	LODSW
	OUT	DX, AX
	MOV	DI, OFFSET _idecd_info_block
	MOV	AX, DS
	MOV	ES, AX
	ADD	DX, 7
	XOR	CX, CX

	MOV	EAX, 49E30H
	CALL	delay

	IN	AL, DX
	TEST	AL, 80H
	JNZ	_ide_cd_ata_info_not_found4
	TEST	AL, 1
	JNZ	_ide_cd_ata_info_not_found4
	TEST	AL, 8
	JNZ	_ide_cd_ata_info_found4
_ide_cd_ata_info_not_found4:
	JMP	_ide_cd_ata_info_not_found

_ide_cd_ata_info_found4:
	SUB	DX, 2
	IN	AL, DX
	MOV	AH, AL
	DEC	DX
	IN	AL, DX
	SUB	AH, AH
	MOV	CX, AX
	INC	CX
	SHR	CX, 1
	OR	CX, CX
	JZ	_ide_cd_ata_info_not_found
	SUB	DX, 4

	REP	INSW
	MOV	CX, 07FH

	MOV	EAX, 49E30H
	CALL	delay

	ADD	DX, 7
	IN	AL, DX
	TEST	AL, 1
	JNZ	_ide_cd_ata_info_complete
	TEST	AL, 8
	JNZ	_ide_cd_ata_info_found4
_ide_cd_ata_info_complete:
	SUB	DI, OFFSET _idecd_info_block
	MOV	AX, DI
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BP
	XOR	DX, DX
	RET
_ide_cd_ata_info_not_found:
	POP	DI
	POP	SI
	POP	BX
	POP	CX
	POP	BP
	XOR	AX, AX
	MOV	DX, AX
	RET

_get_ide_cd_ata_info	ENDP

_TEXT	ENDS

; Data segment.
_DATA	SEGMENT	BYTE PUBLIC 'DATA'
ASSUME	DS:_DATA

_ata_info		DB	3 DUP(0)
			DB	6 DUP(0)
_idecd_info_block	DB	1024 DUP(0)

_DATA	ENDS
	END