/*
 * ERRORS.CPP - Contains error handling functions.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

// ID for this file.
#define _ERRORS_CC_

#include "sysinfo.h"

// General purpose routine to print any errors.
void SysInfo :: checkerrors()
{
 fprintf(stderr, "Error: ");
 switch (errflag) {
	case 0:
	     fprintf(stderr, "No errors ???!!!\r\n");
	     break;

	case 1:
	     fprintf(stderr, "Could not create temporary file\r\n");
	     break;

	case 2:
	     fprintf(stderr, "Could not write to disk (Disk full ?)\r\n");
	     break;

	case 3:
	case 4:
	case 5:
	case 6:
	case 7:
	case 8:
	case 9:
	case 10:
	case 11:
	case 12:
	case 13:
	case 14:
	     fprintf(stderr, "Could not spawn information module\r\n");
	     return;

	default:
		fprintf(stderr, "Unknown error code %d\r\n", errflag);
		break;
 }
 exit(0x7f);
}
