
; * USBCHECK.ASM - Checks for USB and Pentium CPU.
; * Copyright (C) 1998, 1999 Prashant TR
; *
; * This program is free software; you can redistribute it and/or modify
; * it under the terms of the GNU General Public License as published by
; * the Free Software Foundation; either version 2 of the License, or
; * (at your option) any later version.
; *
; * See the file COPYING.TR for more details.

_TEXT	SEGMENT	BYTE PUBLIC 'CODE'
ASSUME	CS:_TEXT
.386P

PUBLIC	_check_usb, _pentium

_check_usb	PROC	FAR
	PUSH    BP
	MOV	BP, SP
	PUSHAD
	MOV	AX, 0B103H
	MOV	ECX, 0C0300H
	MOV	DX, 1
	MOV	SI, [BP + 6]
	INT	1AH
	JC	_check_usb_no_usb
	OR	AH, AH
	POPAD
	JNZ	_check_usb_no_usb1
	XOR	AX, AX
	INC	AX
	MOV	DX, AX
	POP	BP
	RET

_check_usb_no_usb:
	POPAD
_check_usb_no_usb1:
	XOR	AX, AX
	MOV	DX, AX
	POP	BP
	RET

_check_usb	ENDP

_pentium	PROC	FAR
	PUBLIC	_pentium
		PUSHAD
		PUSHFD
		POP	EAX
		OR	EAX, 200000H
		PUSH	EAX
		POPFD
		PUSHFD
		POP	EAX
		TEST	EAX, 200000H
		JZ      _not_pentium
		XOR	EAX, EAX
		INC	AX
		DB	0FH, 0A2H
		AND	AH, 0FH
		CMP	AH, 5
		JB	_not_pentium
		POPAD
		MOV	AX, 1
		RET
_not_pentium:
		POPAD
		XOR	AX, AX
		RET
_pentium	ENDP

_TEXT	ENDS
	END