/* lfnsrv.c -- dll entry and exit point 
   Copyright (C) 1999-2000 Wojciech Galazka

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include "lfnsrv.h"
  
BOOL
WINAPI LFNInitialize(
	IN HINSTANCE DllHandle,
	IN DWORD Reason,
	IN LPVOID Context)
{
	BYTE i;
	switch (Reason) {
		case DLL_PROCESS_ATTACH:
			START_DEBUGGING;
			LFNVERSION();
			for (i= MIN_HANDLES; i < MAX_HANDLES; i++)	
				hFindFile[i] = INVALID_HANDLE_VALUE;
			nHandlesUsed = 0;
			SetFileApisToOEM();
			DisableThreadLibraryCalls(DllHandle);
			break;
		case DLL_PROCESS_DETACH :
			SetFileApisToANSI();
			break;
		default :
			DBGMSG("LFNInitialize: UBKNOWN CALL");
			break;
	}
	return TRUE;
}

VOID
LFNRegisterInit(VOID)
{
	setCF(0);
	return;
}

VOID 
LFNTerminateVDM(VOID)
{
	setCF(0);
	return;
}

