/* getdiskfreespace.c -- get disk free space
   Copyright (C) 1999-2000 Wojciech Galazka

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

//
// Work around int 21h,AH=36h bug
//

#include "lfnsrv.h"

WORD	process_get_disk_free_space(
		IN  BYTE  nDrive,				
		OUT PWORD wSectorsPerCluster,	
		OUT PWORD wBytesPerSector,
		OUT PWORD wFreeClusters,
		OUT PWORD wTotalClusters)
{
	WORD	result;
	DWORD 	dwSectorsPerCluster;
	DWORD 	dwBytesPerSector;   
	DWORD 	dwFreeClusters;    
	DWORD 	dwTotalClusters;  
	char lpDir[]= "A:\\";	
        char *name;

	PROLOG(process_get_disk_free_space);
	ISNULL(wSectorsPerCluster);
	ISNULL(wBytesPerSector   );
	ISNULL(wFreeClusters     );
	ISNULL(wTotalClusters    );
	DBGVALUE(nDrive,"%d");

	if (nDrive) {	
		lpDir[0]= nDrive-1+'A';
		name = &lpDir[0];
	} else
		name = NULL;

	if (!GetDiskFreeSpace(name, &dwSectorsPerCluster, &dwBytesPerSector,  
			&dwFreeClusters, &dwTotalClusters)) {
		result = (WORD)GetLastError();
		DBGMSG("GetDiskFreeSpace call failed");
		DBGVALUE(result,"%d");	
		if (result == ERROR_INVALID_DRIVE &&
		ValidDriveName(name, TRUE) == ERROR_SUCCESS) {
			dwSectorsPerCluster = 0;
			dwBytesPerSector    = 0;
			dwFreeClusters      = 0;
			dwTotalClusters     = 0;
		} else {		
			EPILOG(process_get_disk_free_space, FALSE);
			return result;
		}
	}
                             
	DBGVALUE(dwSectorsPerCluster ,"%x");
	DBGVALUE(dwBytesPerSector    ,"%x");
	DBGVALUE(dwFreeClusters      ,"%x");
	DBGVALUE(dwTotalClusters     ,"%x");

#if 0
	if (dwTotalClusters > 0xffff)  {
		char lpFsName[14];
		if (!GetVolumeInformation(name, NULL, 0, NULL,
				NULL, NULL, lpFsName, sizeof(lpFsName))) {
			result = (WORD)GetLastError();
			DBGVALUE(result,"%d");
			EPILOG(process_get_disk_free_space, FALSE);
			return result;
		}
		DBGVALUE(lpFsName,"%s");		
		if (lstrcmp(lpFsName,"NTFS") == 0) {
			dwSectorsPerCluster <<= 8;
			dwFreeClusters 	    >>= 8;
			dwTotalClusters     >>= 8;
		}
	}

	*wSectorsPerCluster = (dwSectorsPerCluster >0xffff)? 0xffff:LOWORD(dwSectorsPerCluster);   
	*wBytesPerSector    = (dwBytesPerSector    >0xffff)? 0xffff:LOWORD(dwBytesPerSector);   
	*wFreeClusters      = (dwFreeClusters      >0xffff)? 0xffff:LOWORD(dwFreeClusters);     
	*wTotalClusters     = (dwTotalClusters     >0xffff)? 0xffff:LOWORD(dwTotalClusters);    
#else
 	while (dwTotalClusters >= (DWORD)0xffff) {
		dwSectorsPerCluster <<= 1;
		dwFreeClusters 	    >>= 1;
		dwTotalClusters     >>= 1;
	}

	*wSectorsPerCluster = LOWORD(dwSectorsPerCluster);   
	*wBytesPerSector    = LOWORD(dwBytesPerSector);   
	*wFreeClusters      = LOWORD(dwFreeClusters);     
	*wTotalClusters     = LOWORD(dwTotalClusters);    

#endif

	DBGVALUE(*wSectorsPerCluster ,"%x");
	DBGVALUE(*wBytesPerSector    ,"%x");
	DBGVALUE(*wFreeClusters      ,"%x");
	DBGVALUE(*wTotalClusters     ,"%x");
	EPILOG(process_get_disk_free_space,TRUE);
	return ERROR_SUCCESS;
}
