/* converttime.c -- convert file date and time 
   Copyright (C) 1999-2000 Wojciech Galazka

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include "lfnsrv.h"

WORD	process_convert_time(
		IN BYTE nAction,
		IN OUT PWORD pDosDate,
		IN OUT PWORD pDosTime,
		IN OUT PBYTE pDosMilisec,
		IN OUT PFILETIME pTime)
{
	PFILETIME pf;
	FILETIME   f;
	PROLOG(process_convert_time);
	ISNULL(pDosDate);
	ISNULL(pDosTime);	
	ISNULL(pDosMilisec);
	DBGVALUE(nAction,"%d");
////	DBGVALUE(*pDosDate,"%d");
////	DBGVALUE(*pDosTime,"%d");
////	DBGVALUE(*pDosMilisec,"%d");
	if (!pTime) {
		pf = &f;
		memset(pf, 0, sizeof(FILETIME));	
	}
	else 
		pf = pTime;

	switch (nAction)
	{
		case LONG_CONVERT_TIME_TO_DOS :
							 //not sure
			if (!FileTimeToDosDateTime(pf, pDosDate, pDosTime)) {
				EPILOG(process_convert_time, FALSE);
				return (WORD)GetLastError();	
			}
			*pDosMilisec = 0; 
			break;
		case LONG_CONVERT_TIME_FROM_DOS: 
			if (!DosDateTimeToFileTime(*pDosDate, *pDosTime, pf)) {
				EPILOG(process_convert_time, FALSE);
				return (WORD)GetLastError();
			}
			break;
		default:
			EPILOG(process_convert_time, TRUE);
			return ERROR_INVALID_FUNCTION;
	}

////	DBGVALUE(*pDosDate,"%d");
////	DBGVALUE(*pDosTime,"%d");
////	DBGVALUE(*pDosMilisec,"%d");
	EPILOG(process_convert_time, TRUE);
	return ERROR_SUCCESS;
}
