AC_DEFUN(GST_KIND_DLD, [

# Test even if we don't use dynamic loading
AC_MSG_CHECKING(which dynamic loading API is to be used)
exec AS_MESSAGE_FD>/dev/null

AC_ARG_WITH(dld, 
[  --with-dld=path         set path to dynamic linking libraries
  --without-dld      	  don't look for a way to enable dynamic linking])


test "$with_dld" && test -d "$with_dld" && LDFLAGS="$LDFLAGS -L$with_dld"

which=
# for syntax is: Header Library Function Result
DLD_MODULE=none
test $PLATFORM = win32 && DLD_MODULE=win32
for item in	ltdl.h ltdl lt_dlopenext ltdl		\
		dlfcn.h dl dlopen libdl			\
		dl.h dld shl_load hpux			\
  		dld.h dld dld_get_func gnu		\
		ldfcn.h ld load aix			; do
  which=x$which
  case $which in
    x)    header=$item ;;
    xx)   lib=$item ;;
    xxx)  func=$item ;;
    xxxx) which=
      AC_CHECK_HEADER($header, [
	AC_CHECK_LIB($lib, $func, [
	  LIBS="$LIBS -l$lib" DLD_MODULE=$item
	  break
        ])
      ]) ;;
  esac
done

test "$silent" != yes && exec AS_MESSAGE_FD>&1
AC_MSG_RESULT($DLD_MODULE)

DLD_MODULE=dld_$DLD_MODULE
test "$with_dld" = no && DLD_MODULE=dld_none
if test "$DLD_MODULE" != dld_none; then
  AC_DEFINE(HAVE_DLD, 1, [Define if your system's dynamic loading method is supported.])
  AC_CACHE_CHECK(for leading _ in shared libraries, gst_cv_dlsym_underscore,
    path_to_libc=`ls /lib/lib*c.so /usr/lib/lib*c.so \
	     /lib/lib*c.sl /usr/lib/lib*c.sl \
             /bin/cygwin*.dll /gnuwin32/cygwin*.dll \
             /lib/lib*c.a* /usr/lib/lib*c.a 2> /dev/null | head -1`

    AC_TRY_RUN([
      #ifdef OLDCC
      typedef char *voidPtr;
      #else
      typedef void *voidPtr;
      #endif
      #define __GSTDLD__			/* avoid including dld_gst.h */
      #include "$srcdir/lib/$DLD_MODULE.c"	/* include the wrappers here */
      main(argc, argv)
           int	argc;
           char	**argv;
      {
	voidPtr lib;
	gst_dld_init(*argv);
	lib = gst_dld_open("$path_to_libc");
	exit(gst_dld_sym(lib, "printf") != NULL);
      }], gst_cv_dlsym_underscore=no, gst_cv_dlsym_underscore=yes
  ))

  if test "$gst_cv_dlsym_underscore" = yes; then
    AC_DEFINE(NEED_DLSYM_UNDERSCORE, 1,
              [Define if your system's dynamic loading method needs a _ to be prepended to the function name.])
  fi
fi

AC_SUBST(DLD_MODULE)
])dnl
