/***********************************************************************
 *
 *	GDBM interface definitions for GNU Smalltalk 
 *
 *	$Revision: 1.7.5$
 *	$Date: 2000/05/28 16:56:52$
 *	$Author: pb$
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
 * Written by Steve Byrne.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 ***********************************************************************/

/*
 *    Change Log
 * ============================================================================
 * Author      Date       Change 
 * sbb	     16 Sep 95	  created change log.
 *
 */


#include "gstpub.h"
#include <gdbm.h>

#include <malloc.h>

/* It might be a good idea to have the make file in this directory
 * automatically run configure if it hasn't already been run, to ensure
 * that the definitions in use reflect things which are actually present
 * in the local environment (such as some of the gdbm_ functions which are
 * only present after particular versions) */

/*
     GDBM_FILE gdbm_open(name, block_size, flags, mode, fatal_func);
     void gdbm_close(dbf);
     int gdbm_store(dbf, key, content, flag);
     datum gdbm_fetch(dbf, key);
     int gdbm_delete(dbf, key);
     datum gdbm_firstkey(dbf);
     datum gdbm_nextkey(dbf, key);
     int gdbm_reorganize(dbf);
     void gdbm_sync(dbf); -- new
     int gdbm_exists(dbf, key); not present
     char *gdbm_strerror(errno); -- new 
     int gdbm_setopt(dbf, option, value, size) -- new
*/

int
Wrapped_gdbm_store(dbf, key, content, flag)
     GDBM_FILE dbf;
     datum* key;
     datum* content;
     int flag;
{
  return gdbm_store(dbf, *key, *content, flag);
}

datum*
Wrapped_gdbm_fetch(dbf, key)
     GDBM_FILE dbf;
     datum* key;
{
  datum* result;
  /* 
     printf("key is %d\n", key->dsize);
     printf("key value is %s\n", key->dptr);
  */
  result = (datum*)malloc(sizeof(datum));
  *result = gdbm_fetch(dbf, *key);
  /*
     printf("result length is %d ptr is %x\n", result->dsize, result->dptr);
  */
  return result;
}

int
Wrapped_gdbm_delete(dbf, key)
     GDBM_FILE dbf;
     datum* key;
{
  return gdbm_delete(dbf, *key);
}

datum*
Wrapped_gdbm_firstkey(dbf)
     GDBM_FILE dbf;
{
  datum* result;
  result = (datum*)malloc(sizeof(datum));
  *result = gdbm_firstkey(dbf);
  return result;
}

datum*
Wrapped_gdbm_nextkey(dbf, key)
     GDBM_FILE dbf;
     datum* key;
{
  datum* result;
  result = (datum*)malloc(sizeof(datum));
  *result = gdbm_nextkey(dbf, *key);
  return result;
}

/*
int
Wrapped_gdbm_exists(dbf, key)
     GDBM_FILE dbf;
     datum* key;
{
  return gdbm_exists(dbf, *key);
}
*/

void
initGdbm()
{
  /* the use of the Wrapped_ functions is an artifact of the limitation of C
     that you cannot reliably and portably synthesize a function call where
     some of the parameters are by-value structs.  Other than the use of
     pointers to datums instead of by-value datum structures, the signatures
     are identical to the normal gdbm functions */
  defineCFunc("gdbm_open", gdbm_open);
  defineCFunc("gdbm_close", gdbm_close);
  defineCFunc("gdbm_store", Wrapped_gdbm_store);
  defineCFunc("gdbm_fetch", Wrapped_gdbm_fetch);
  defineCFunc("gdbm_delete", Wrapped_gdbm_delete);
  defineCFunc("gdbm_firstkey", Wrapped_gdbm_firstkey);
  defineCFunc("gdbm_nextkey", Wrapped_gdbm_nextkey);
  defineCFunc("gdbm_reorganize", gdbm_reorganize);
/*  defineCFunc("gdbm_sync", gdbm_sync); not universal */
/*  defineCFunc("gdbm_exists", Wrapped_gdbm_exists); */
/*   defineCFunc("gdbm_strerror", gdbm_strerror); not universal */
/*  defineCFunc("gdbm_setopt", gdbm_setopt); not universal */
}
