#! /bin/sh
#
# I used this script to generate GCC-3.2.3 documentation package for DJGPP.
# This script is tested (with small modifications) only under Linux.
#
srcdir=`(cd ${1-../gcc-3.23}; pwd)`
builddir=`(cd ../build.gcc; pwd)`
#
MAKEINFO=$DJDIR/makeinfo
DVIPS=dvips
DVIPDF=dvipdfm
#
TOP=`pwd`
version=`grep version_string $srcdir/gcc/version.c |\
         sed -e 's/.*\"\(.*\)\".*/\1/'`
ver1=`echo $version | sed -e 's/\.//2'`
ver2=`echo $version | sed -e 's/\.//g'`
docdir=gnudocs/gcc-$ver1
MKHTML='$MAKEINFO --no-split --number-sections --html'

mkdir -p $docdir

cd $builddir || exit 1
make dvi
for x in `find . -name '*.dvi'` ; do cp -v $x $TOP/$docdir/`basename $x`; done

cd $srcdir/libiberty || exit 1
$MKHTML libiberty.texi
cp -v libiberty.html $TOP/$docdir/

cd $srcdir/gcc/doc || exit 1
for x in cpp cppinternals gcc gccint ../f/g77; do
  ( cd `dirname $x` && $MKHTML -I ../doc/include `basename $x.texi` )
  cp -v $x.html $TOP/$docdir/
done

cd $TOP/$docdir
for x in *.dvi ; do 
  $DVIPS $x
  $DVIPDF $x
done

cd $TOP
if ! [ -d manifest ] ; then mkdir manifest; fi
echo "gcc$ver2.zip GCC-$version documentation" >manifest/gcc${ver2}d.ver
echo "" >>manifest/gcc${ver2}d.mft
( find manifest -type f -a -name "gcc${ver2}d.*"; \
  find gnudocs -type f ) | sort >manifest/gcc${ver2}d.mft
rm -f gcc${ver2}d.zip
cat manifest/gcc${ver2}d.mft | zip -9@ gcc${ver2}d.zip
