#!/bin/sh
# MakeTeXnames -- find PK and TFM names.
# Use alias files from the ftp://ftp.tug.org/tex/fontname.tar.gz distribution.
# te@informatik.uni-hannover.de and kb@mail.tug.org. Public domain.

version='$Id: MakeTeXnames,v 1.7 1997/02/08 15:52:15 karl Exp karl $'
usage="Usage: $0 NAME [DPI MODE] [DESTDIR].
  Output the PK and TFM names for a font NAME."
mt_max_args=4

: ${TEXMFMAIN=`kpsewhich -expand-var='$TEXMFMAIN'`}
if test -z "$TEXMFMAIN"; then
  echo "$0: No \$TEXMFMAIN; set the environment variable or in texmf.cnf." >&2
  exit 1
fi
: ${TEXMFCNF_DIR=`kpsewhich -expand-var='$TEXMFCNF_DIR'`}
test -n "$TEXMFCNF_DIR" || TEXMFCNF_DIR=$TEXMFMAIN/web2c
. $TEXMFCNF_DIR/MakeTeXcommon

: ${TEXMFLS_R=`kpsewhich -expand-var='$TEXMFLS_R'`}
test -n "$TEXMFLS_R" || TEXMFLS_R=$TEXMFMAIN

NAME=$1
case $# in
1|2) DPI=$BDPI; DEST=$2;;
3|4) DPI=$2;  MODE=$3;    DEST=$4;;
*)   help;;
esac

FONTNAME=`kpsewhich -expand-var='$FONTNAME'`
test -z "$FONTNAME" && FONTNAME=$TEXMFMAIN/fontname

: ${MT_PKDESTDIR='$MT_DESTROOT/$MT_PKPART/$MT_MODE/$MT_NAMEPART'}
: ${MT_TFMDESTDIR='$MT_DESTROOT/$MT_TFMPART/$MT_NAMEPART'}
: ${MT_DESTROOT='$TEXMFLS_R/fonts'}
: ${MT_DEFAULT_NAMEPART=tmp}
: ${MT_PKPART='pk'}
: ${MT_TFMPART='tfm'}
: ${MT_TFMNAME='$NAME.tfm'}
: ${MT_PKNAME='$NAME.${DPI}pk'}

# MT_NAMEPART is harder.
if test -z "$MT_NAMEPART"; then
  # Nothing specified, so try to intuit the directory from the
  # fontname. First the special cases: either $NAME matches an entire
  # name in special.map, or it matches the abbreviation in
  # special.map and ends with a numeral (for the pointsize).
  # We (painfully) use only the minimal features in original awk.
  if test -r $FONTNAME/special.map; then
    MT_NAMEPART=`awk \
'{if ($1 == NAME || (substr (NAME, 1, length ($1)) == $1 \
                  && substr (NAME, length (NAME), 1) ~ /[0-9]/ \
                  && substr ($1, length ($1), 1) ~ /[^0-9]/)) \
 { print $2 "/" $3; exit; }}' NAME=$NAME $FONTNAME/special.map`

    if test -z "$MT_NAMEPART"; then
      # Try the normal case. Source first.
      s_abbrev=`echo $NAME | sed 's/^\(.\).*$/\1/'`
      sourcedir=`awk '{ if ($1 == s_abbrev) { print $2; exit; }}' \
                 s_abbrev=$s_abbrev $FONTNAME/supplier.map`

      if test -n "$sourcedir"; then
        # We found the source. Try for the typeface.
        t_abbrev=`echo $NAME | cut -c 2-3`
        typefacedir=`awk '{ if ($1 == t_abbrev) { print $2; exit; }}' \
                     t_abbrev=$t_abbrev $FONTNAME/typeface.map`

        if test -n "$typefacedir"; then
          # Found everything.
          MT_NAMEPART=$sourcedir/$typefacedir

        else
          echo "$0: Could not map typeface abbreviation $t_abbrev." >&2
        fi
      else
        echo "$0: Could not map source abbreviation $s_abbrev." >&2
      fi
    fi
  fi
  if test -z "$MT_NAMEPART"; then
    # If we failed for whatever reason, default to a generic subdir.
    MT_NAMEPART=$MT_DEFAULT_NAMEPART
  fi
fi

case "$DEST" in
  "") ;;
  /* | [A-z]:/*) MT_PKDESTDIR=$DEST;; # Absolute, explicit destdir => use it.
   *) MT_NAMEPART=$DEST;; # Relative destdir => append to the default.
esac

. $TEXMFCNF_DIR/MakeTeXnames.cnf

eval MT_MODE=$MODE
eval MT_PKPART=$MT_PKPART
eval MT_DESTROOT=$MT_DESTROOT
eval PKNAME=$MT_PKDESTDIR/$MT_PKNAME
eval TFMNAME=$MT_TFMDESTDIR/$MT_TFMNAME

echo $PKNAME $TFMNAME | sed 's@//*@/@g'
