/*    EPZip - the simple free distribution preparing tool
**    Copyright (C) 1997  Esa Peuha

**    This program is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation; either version 2 of the License, or
**    (at your option) any later version.

**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.

**    You should have received a copy of the GNU General Public License
**    along with this program; if not, write to the Free Software
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <crt0.h>
#include <stdio.h>
#include "epzip.h"

void __crt0_load_environment_file(char *);
static void print_usage(void);

int main(int argc, char **argv)
{
  FILE *outfile;

  if(argc < 2)
    {
      print_usage();
      exit(1);
    }
  ++argv;
  --argc;

  outfile=fopen(*argv, "wb");
  if(outfile == NULL)
    {
      fprintf(stderr, "epzip: can't open output file \"%s\"", *argv);
      perror("");
      exit(1);
    }

  begin_process(outfile);
  for(;++argv, --argc;)
    {
      printf(*argv);
      fflush(stdout);
      process_file(outfile, *argv);
      printf(" ok\n");
    }
  end_process(outfile);

  fclose(outfile);

  return 0;
}

static void print_usage(void)
{
  fprintf(stderr, "\nUsage: epzip outfile infile [ infile [ infile ... ] ]\n");
}

void __crt0_load_environment_file(char *_app_name)
{
}
