/* Copyright (C) 1996,1997,1998,1999 by Salvador E. Tropea (SET),
   see copyrigh file for details */
#ifndef __CEDITINT_H_SET_
#define __CEDITINT_H_SET_

// International support from TV
#include <intl.h>

#ifndef HAVE_INTL_SUPPORT
#define NO_INTL_SUP
#endif

// Configuration for the Editor:
// Note: Starting with 0.4.23 I'm changing the mechanism.
//   There are two main configurations, one is for the standalone editor and
// is the default. The other is used for RHIDE to create libset.a to enable
// it you must define FOR_LIBSET *externally*. So the libset.gpr/mak have
// this define and only includes other projects not affected by ceditint.h.
//   Projects like easydiag, settvuti and extra shouldn't include ceditint.h
// or at least don't rely in features that are related to the FOR_LIBSET
// definition.

// ** Shared options
// Cache the colors in editorfo.cc to avoid calling getColor() all the time
#define CACHED_COLORS
// Gzip support is inside the editor using libz. The support for external
// gzip is broken and I don't think is a good idea to fix it.
#define SUP_GZ

#ifndef FOR_LIBSET
# define STANDALONE
# define SUP_SDG
#else
#endif

// Starting with 0.4.36 I have a small configure script to determine the
// following:
#include <configed.h>

// MP3 support only for standalone and if Allegro is installed
#if defined(HAVE_ALLEGRO) && defined(STANDALONE)
#define SUP_MP3
#endif

// PCRE support
#if defined(HAVE_PCRE_LIB)
#define SUP_PCRE
#endif

#ifdef HAVE_PCRE206
#define PCRE206 0,
#else
#define PCRE206
#endif

// Tabs setings

#ifdef Tabs8
#define AdvanceWithTab(a,b)     if (a==9) b|=7; b++
#define NextTabPos(x)           (((x/8)+1)*8)
#define MoveWithTab(b)          b|=7; b++
#define IsATabPos(a)            (a%8)==0
#else
#define AdvanceWithTab(a,b)     if (a==9) b+=tabSize-(b%tabSize); else b++
#define NextTabPos(x)           (((x/tabSize)+1)*tabSize)
#define MoveWithTab(b)          b+=tabSize-(b%tabSize)
#define IsATabPos(a)            (a%tabSize)==0
#endif

// End Of Line settings

#define IsntEOL(a) (a!='\r' && a!='\n')
#define IsEOL(a)   (a=='\r' || a=='\n')
#ifdef __DJGPP__
#define LenEOL     2
const char crlf[] = "\r\n";
#define USE_CRLF
#define IsTrueEOL(a) (a=='\r' || a=='\n')
#else
#define LenEOL     1
const char crlf[] = "\n";
#define IsTrueEOL(a) (a=='\n')
#endif

// Non standard libc stuff

#ifdef __DJGPP__
#define IDLE_SLEEP 0
#else
// This condition is weak, I know, but by now is enough
extern "C" char *strlwr(char *s);
#define NEEDS_STRLWR
extern "C" char *strupr(char *s);
#define NEEDS_STRUPR
#define stricmp  strcasecmp
#define strnicmp strncasecmp

#ifndef O_BINARY
#define O_BINARY 0
#endif // !O_BINARY

#define IDLE_SLEEP 1000

#endif // !__DJGPP__

void yieldProcessor(int micros=0); // DPMI yield and/or just sleep

//
// Debug printf. Defining DEBUG the program prints to stderr.
//
#ifndef DEBUG
#define dbprintf(a...)
#else
# ifndef TO_STDOUT
#  define dbprintf(a...) fprintf(stderr,a)
# else
#  define dbprintf(a...) printf(a)
# endif
#endif

#endif // __CEDITINT_H_SET_
